/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.BlockModelBakingContextImpl;
import com.supermartijn642.fusion.model.ItemModelBakingContextImpl;
import com.supermartijn642.fusion.model.ModelInstanceImpl;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10096;
import net.minecraft.class_10401;
import net.minecraft.class_10419;
import net.minecraft.class_10439;
import net.minecraft.class_10813;
import net.minecraft.class_10819;
import net.minecraft.class_10820;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_5599;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class FusionBlockModel
extends class_793 {
    public static final ThreadLocal<class_2960> CURRENT_MODEL = new ThreadLocal();
    private final class_2960 name;
    private final ModelInstance<?> model;
    private final class_1100 vanillaModel;
    private Collection<class_2960> dependencies;
    private Map<class_2960, class_1100> resolvedDependencies;

    public FusionBlockModel(ModelInstance<?> model) {
        super(null, null, null, null, new class_10419.class_10420(Map.of()), null);
        class_2960 name = CURRENT_MODEL.get();
        this.name = name == null ? IdentifierUtil.withFusionNamespace("unknown") : name;
        this.model = model;
        this.vanillaModel = model.getAsVanillaModel();
    }

    public class_1087 bakeBlockModel(class_10819 wrapper, class_7775 modelBakery, class_3665 modelState) {
        this.resolveDependencies(modelBakery);
        BlockModelBakingContextImpl context = new BlockModelBakingContextImpl(modelBakery, material -> modelBakery.method_65732().method_65739(material, (class_10813)wrapper), modelState, this.name, this.resolvedDependencies, wrapper.method_68045().field_55277, wrapper.method_68040(), wrapper.method_68042().method_24299(), wrapper.method_68043(), wrapper.method_68044());
        try {
            return this.model.bakeBlockModel(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception while baking block model of type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
        }
    }

    public class_10439 bakeItemModel(class_10819 wrapper, class_7775 modelBakery, List<class_10401> tintSources, class_5599 entityModelSet) {
        this.resolveDependencies(modelBakery);
        ItemModelBakingContextImpl context = new ItemModelBakingContextImpl(modelBakery, material -> modelBakery.method_65732().method_65739(material, (class_10813)wrapper), this.name, this.resolvedDependencies, wrapper.method_68045().field_55277, wrapper.method_68040(), wrapper.method_68042().method_24299(), wrapper.method_68043(), wrapper.method_68044(), tintSources, entityModelSet);
        try {
            return this.model.bakeItemModel(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception while baking item model of type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
        }
    }

    private Map<class_2960, class_1100> resolveDependencies(class_7775 modelBaker) {
        if (this.resolvedDependencies != null) {
            return this.resolvedDependencies;
        }
        if (this.dependencies == null) {
            try {
                this.dependencies = this.model.getModelDependencies();
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst requesting dependencies from model type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
            }
            if (this.dependencies == null) {
                throw new RuntimeException("Model type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' returned null when requesting dependencies '" + String.valueOf(this.name) + "'!");
            }
        }
        this.resolvedDependencies = new HashMap<class_2960, class_1100>(this.dependencies.size());
        for (class_2960 location : this.dependencies) {
            this.resolvedDependencies.put(location, modelBaker.method_45872(location).method_68031());
        }
        LinkedList<class_2960> unresolved = new LinkedList<class_2960>(this.dependencies);
        while (!unresolved.isEmpty()) {
            class_2960 location;
            location = (class_2960)unresolved.removeFirst();
            class_1100 unbakedModel = this.resolvedDependencies.get(location);
            if (unbakedModel instanceof FusionBlockModel) {
                FusionBlockModel fusionBlockModel = (FusionBlockModel)unbakedModel;
                this.resolvedDependencies.putAll(fusionBlockModel.resolveDependencies(modelBaker));
                continue;
            }
            class_2960 parent = unbakedModel.comp_3744();
            if (parent == null) continue;
            this.resolvedDependencies.put(parent, modelBaker.method_45872(parent).method_68031());
            unresolved.add(parent);
        }
        this.resolvedDependencies.put(class_10096.field_53660, modelBaker.method_45872(class_10096.field_53660).method_68031());
        return this.resolvedDependencies;
    }

    public boolean hasVanillaModel() {
        return this.vanillaModel != null;
    }

    public class_1100 getVanillaModel() {
        return this.vanillaModel;
    }

    @Nullable
    public class_10820 comp_3739() {
        return this.vanillaModel == null ? null : this.vanillaModel.comp_3739();
    }

    @Nullable
    public class_1100.class_4751 comp_3740() {
        return this.vanillaModel == null ? null : this.vanillaModel.comp_3740();
    }

    @Nullable
    public Boolean comp_3741() {
        return this.vanillaModel == null ? null : this.vanillaModel.comp_3741();
    }

    @Nullable
    public class_809 comp_3742() {
        return this.vanillaModel == null ? null : this.vanillaModel.comp_3742();
    }

    public class_10419.class_10420 comp_3743() {
        return this.vanillaModel == null ? new class_10419.class_10420(Map.of()) : this.vanillaModel.comp_3743();
    }

    @Nullable
    public class_2960 comp_3744() {
        return this.vanillaModel == null ? null : this.vanillaModel.comp_3744();
    }

    public static ModelInstance<?> getModelInstance(class_1100 model) {
        if (model instanceof FusionBlockModel) {
            return ((FusionBlockModel)model).model;
        }
        if (model instanceof class_793) {
            ModelInstance<?> modelInstance = ((BlockModelExtension)model).getFusionModel();
            if (modelInstance == null) {
                modelInstance = new ModelInstanceImpl<class_793>(DefaultModelTypes.VANILLA, (class_793)model);
                ((BlockModelExtension)model).setFusionModel(modelInstance);
            }
            return modelInstance;
        }
        return new ModelInstanceImpl<class_1100>(DefaultModelTypes.UNKNOWN, model);
    }
}

