/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.scrolling;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.textures.GpuTexture;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.ScrollingTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.stream.IntStream;
import net.minecraft.class_1058;
import net.minecraft.class_7368;
import net.minecraft.class_7764;
import net.minecraft.class_7768;
import net.minecraft.class_7771;

public class ScrollingTextureType
implements TextureType<ScrollingTextureData> {
    @Override
    public ScrollingTextureData deserialize(JsonObject json) throws JsonParseException {
        ScrollingTextureData.Builder builder = ScrollingTextureData.builder();
        if (json.has("from")) {
            ScrollingTextureData.Position from;
            if (!json.get("from").isJsonPrimitive() || !json.getAsJsonPrimitive("from").isString()) {
                throw new JsonParseException("Property 'from' must be a string!");
            }
            String fromString = json.get("from").getAsString();
            try {
                from = ScrollingTextureData.Position.valueOf(fromString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'from' must be one of " + Arrays.toString((Object[])ScrollingTextureData.Position.values()).toLowerCase(Locale.ROOT) + ", not '" + fromString + "'!");
            }
            builder.startPosition(from);
        }
        if (json.has("to")) {
            ScrollingTextureData.Position to;
            if (!json.get("to").isJsonPrimitive() || !json.getAsJsonPrimitive("to").isString()) {
                throw new JsonParseException("Property 'to' must be a string!");
            }
            String toString = json.get("to").getAsString();
            try {
                to = ScrollingTextureData.Position.valueOf(toString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'to' must be one of " + Arrays.toString((Object[])ScrollingTextureData.Position.values()).toLowerCase(Locale.ROOT) + ", not '" + toString + "'!");
            }
            builder.endPosition(to);
        }
        if (json.has("frame_time")) {
            if (!json.get("frame_time").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_time").isNumber()) {
                throw new JsonParseException("Property 'frame_time' must be an integer!");
            }
            int frameTime = json.get("frame_time").getAsNumber().intValue();
            if (frameTime <= 0) {
                throw new JsonParseException("Property 'frame_time' must have a value greater than 0!");
            }
            builder.frameTime(frameTime);
        }
        if (json.has("frame_width")) {
            if (!json.get("frame_width").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_width").isNumber()) {
                throw new JsonParseException("Property 'frame_width' must be an integer!");
            }
            int frameWidth = json.get("frame_width").getAsNumber().intValue();
            if (frameWidth <= 0) {
                throw new JsonParseException("Property 'frame_width' must have a value greater than 0!");
            }
            builder.frameWidth(frameWidth);
        }
        if (json.has("frame_height")) {
            if (!json.get("frame_height").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_height").isNumber()) {
                throw new JsonParseException("Property 'frame_height' must be an integer!");
            }
            int frameHeight = json.get("frame_height").getAsNumber().intValue();
            if (frameHeight <= 0) {
                throw new JsonParseException("Property 'frame_height' must have a value greater than 0!");
            }
            builder.frameHeight(frameHeight);
        }
        if (json.has("loop_type")) {
            ScrollingTextureData.LoopType loopType;
            if (!json.get("loop_type").isJsonPrimitive() || !json.getAsJsonPrimitive("loop_type").isString()) {
                throw new JsonParseException("Property 'loop_type' must be a string!");
            }
            String loopTypeString = json.get("loop_type").getAsString();
            try {
                loopType = ScrollingTextureData.LoopType.valueOf(loopTypeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'loop_type' must be one of " + Arrays.toString((Object[])ScrollingTextureData.LoopType.values()).toLowerCase(Locale.ROOT) + ", not '" + loopTypeString + "'!");
            }
            builder.loopType(loopType);
        }
        if (json.has("loop_pause")) {
            if (!json.get("loop_pause").isJsonPrimitive() || !json.getAsJsonPrimitive("loop_pause").isNumber()) {
                throw new JsonParseException("Property 'loop_pause' must be an integer!");
            }
            int loopPause = json.get("loop_pause").getAsNumber().intValue();
            if (loopPause < 0) {
                throw new JsonParseException("Property 'loop_pause' must have a positive value!");
            }
            builder.loopPause(loopPause);
        }
        return (ScrollingTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ScrollingTextureData data) {
        JsonObject json = new JsonObject();
        if (data.getStartPosition() != ScrollingTextureData.Position.TOP_LEFT) {
            json.addProperty("from", data.getStartPosition().name().toLowerCase(Locale.ROOT));
        }
        if (data.getEndPosition() != ScrollingTextureData.Position.BOTTOM_LEFT) {
            json.addProperty("to", data.getEndPosition().name().toLowerCase(Locale.ROOT));
        }
        if (data.getFrameTime() != 10) {
            json.addProperty("frame_time", (Number)data.getFrameTime());
        }
        if (data.getFrameWidth() != 16) {
            json.addProperty("frame_width", (Number)data.getFrameWidth());
        }
        if (data.getFrameHeight() != 16) {
            json.addProperty("frame_height", (Number)data.getFrameHeight());
        }
        if (data.getLoopType() != ScrollingTextureData.LoopType.RESET) {
            json.addProperty("loop_type", data.getLoopType().name().toLowerCase(Locale.ROOT));
        }
        if (data.getLoopPause() != 0) {
            json.addProperty("loop_pause", (Number)data.getLoopPause());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ScrollingTextureData data) {
        if (context.getTextureWidth() < data.getFrameWidth() || context.getTextureHeight() < data.getFrameHeight()) {
            throw new RuntimeException("Frame size must be smaller than the texture size!");
        }
        return Pair.of(data.getFrameWidth(), data.getFrameHeight());
    }

    @Override
    public class_1058 createSprite(SpriteCreationContext context, ScrollingTextureData data) {
        float percentage;
        int index;
        boolean reverse = data.getLoopType() == ScrollingTextureData.LoopType.REVERSE;
        int startX = data.getStartPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getStartPosition() == ScrollingTextureData.Position.BOTTOM_LEFT ? 0 : context.getTextureWidth() - data.getFrameWidth();
        int startY = data.getStartPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getStartPosition() == ScrollingTextureData.Position.TOP_RIGHT ? 0 : context.getTextureHeight() - data.getFrameHeight();
        int endX = data.getEndPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getEndPosition() == ScrollingTextureData.Position.BOTTOM_LEFT ? 0 : context.getTextureWidth() - data.getFrameWidth();
        int endY = data.getEndPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getEndPosition() == ScrollingTextureData.Position.TOP_RIGHT ? 0 : context.getTextureHeight() - data.getFrameHeight();
        int stepCount = Math.max(Math.abs(endX - startX), Math.abs(endY - startY)) + 1;
        int frameCount = reverse ? Math.max((stepCount - 1) * 2, 1) : stepCount;
        int[] xPositions = new int[frameCount];
        int[] yPositions = new int[frameCount];
        int[] frameTimes = new int[frameCount];
        for (index = 0; index < stepCount; ++index) {
            percentage = stepCount > 1 ? (float)index / (float)(stepCount - 1) : 0.5f;
            xPositions[index] = Math.round((float)startX + (float)(endX - startX) * percentage);
            yPositions[index] = Math.round((float)startY + (float)(endY - startY) * percentage);
            frameTimes[index] = data.getFrameTime();
        }
        int n = stepCount - 1;
        frameTimes[n] = frameTimes[n] + data.getLoopPause();
        if (reverse) {
            for (index = 1; index < stepCount - 1; ++index) {
                percentage = 1.0f - (float)index / (float)(stepCount - 1);
                xPositions[index + stepCount - 1] = Math.round((float)startX + (float)(endX - startX) * percentage);
                yPositions[index + stepCount - 1] = Math.round((float)startY + (float)(endY - startY) * percentage);
                frameTimes[index + stepCount - 1] = data.getFrameTime();
            }
            frameTimes[0] = frameTimes[0] + data.getLoopPause();
        }
        ScrollingSpriteContents contents = new ScrollingSpriteContents(context.createOriginalSprite().method_45851(), xPositions, yPositions, frameTimes);
        return new BaseTextureSprite(context.getTextureIdentifier(), contents, context.getAtlasWidth(), context.getAtlasHeight(), context.getSpritePositionX(), context.getSpritePositionY(), data);
    }

    private static class ScrollingSpriteContents
    extends class_7764 {
        private final int[] xPositions;
        private final int[] yPositions;
        private final int[] frameTimes;
        private int frame;
        private int tickCounter;

        public ScrollingSpriteContents(class_7764 original, int[] xPositions, int[] yPositions, int[] frameTimes) {
            super(original.method_45816(), new class_7771(original.method_45807(), original.method_45815()), original.field_40539, class_7368.field_38688);
            this.xPositions = xPositions;
            this.yPositions = yPositions;
            this.frameTimes = frameTimes;
            this.field_40540 = original.field_40540;
            this.field_40541 = new ScrollingAnimatedTexture();
        }

        private void tick(int x, int y, GpuTexture gpuTexture) {
            if (++this.tickCounter >= this.frameTimes[this.frame]) {
                this.frame = (this.frame + 1) % this.xPositions.length;
                this.tickCounter = 0;
                this.uploadFrame(x, y, this.frame, gpuTexture);
            }
        }

        private void uploadFrame(int x, int y, int frame, GpuTexture gpuTexture) {
            this.method_45811(x, y, this.xPositions[frame], this.yPositions[frame], this.field_40540, gpuTexture);
        }

        public IntStream method_45817() {
            return IntStream.of(1);
        }

        private class ScrollingAnimatedTexture
        extends class_7764.class_5790 {
            public ScrollingAnimatedTexture() {
                super((class_7764)ScrollingSpriteContents.this, Collections.emptyList(), 1, false);
            }

            public class_7768 method_45823() {
                return new class_7768(){

                    public void method_45824(int x, int y, GpuTexture gpuTexture) {
                        ScrollingSpriteContents.this.tick(x, y, gpuTexture);
                    }

                    public void close() {
                    }
                };
            }

            public void method_33445(int x, int y, GpuTexture gpuTexture) {
                ScrollingSpriteContents.this.uploadFrame(x, y, 0, gpuTexture);
            }

            public IntStream method_33450() {
                return ScrollingSpriteContents.this.method_45817();
            }
        }
    }
}

