/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.SpriteContentsExtension;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class}, priority=900)
public class SpriteLoaderMixin {
    @Final
    @Shadow
    private ResourceLocation location;

    @Inject(method={"loadAndStitch(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceLocation;ILjava/util/concurrent/Executor;Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private void initializeTextures(ResourceManager resourceManager, ResourceLocation atlas, int i, Executor executor, Collection<?> metadataSections, CallbackInfoReturnable<CompletableFuture<SpriteLoader.Preparations>> ci) {
        ((CompletableFuture)ci.getReturnValue()).thenApply(preparations -> {
            Map textures = preparations.regions();
            for (Map.Entry entry : textures.entrySet()) {
                TextureAtlasSprite newTexture;
                ResourceLocation identifier = (ResourceLocation)entry.getKey();
                TextureAtlasSprite texture = (TextureAtlasSprite)entry.getValue();
                Pair<TextureType<Object>, Object> textureData = ((SpriteContentsExtension)texture.contents()).fusionTextureMetadata();
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl((SpriteLoader.Preparations)preparations, this.location, texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    FusionClient.LOGGER.error("Encountered an exception whilst initialising texture '{}' for texture type '{}'!", new Object[]{identifier, TextureTypeRegistryImpl.getIdentifier(textureData.left()), e});
                    continue;
                }
                if (newTexture == null) {
                    FusionClient.LOGGER.error("Received null texture from texture type '{}' for texture '{}'!", (Object)TextureTypeRegistryImpl.getIdentifier(textureData.left()), (Object)identifier);
                    continue;
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.put(identifier, newTexture);
                ((SpriteContentsExtension)texture.contents()).clearFusionTextureMetadata();
            }
            return preparations;
        });
    }
}

