/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PaneCullingBakedModel
extends WrappedBakedModel {
    private static final BooleanProperty[] SIDE_PROPERTIES = new BooleanProperty[]{null, null, BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};
    private final MutableQuad helperMutableQuad = new MutableQuad();

    public PaneCullingBakedModel(BlockStateModel original) {
        super(original);
    }

    @Override
    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        BlockState below;
        if (state == null) {
            parts.addAll(super.collectParts(level, pos, state, random));
            return;
        }
        if (!(state.hasProperty((Property)BlockStateProperties.NORTH) || state.hasProperty((Property)BlockStateProperties.SOUTH) || state.hasProperty((Property)BlockStateProperties.WEST) || state.hasProperty((Property)BlockStateProperties.EAST))) {
            parts.addAll(super.collectParts(level, pos, state, random));
            return;
        }
        BlockState above = level.getBlockState(pos.above()).getAppearance(level, pos.above(), Direction.DOWN, state, pos);
        if (above.getBlock() != state.getBlock()) {
            above = null;
        }
        if ((below = level.getBlockState(pos.below()).getAppearance(level, pos.below(), Direction.UP, state, pos)).getBlock() != state.getBlock()) {
            below = null;
        }
        if (above == null && below == null) {
            parts.addAll(super.collectParts(level, pos, state, random));
            return;
        }
        Pair<BlockState, BlockState> neighbors = Pair.of(above, below);
        for (BlockModelPart part : super.collectParts(level, pos, state, random)) {
            parts.add(new FilteringModelPart(part, neighbors));
        }
    }

    private List<BakedQuad> getQuads(BlockModelPart part, Pair<BlockState, BlockState> neighbors, @Nullable Direction cullDirection) {
        List quads = part.getQuads(cullDirection);
        ArrayList<BakedQuad> culledQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            if (!this.filterQuad(quad, neighbors.left(), neighbors.right())) continue;
            culledQuads.add(quad);
        }
        return culledQuads;
    }

    private boolean filterQuad(BakedQuad bakedQuad, BlockState stateAbove, BlockState stateBelow) {
        Direction quadDirection = bakedQuad.direction();
        if (quadDirection != Direction.UP && quadDirection != Direction.DOWN) {
            return true;
        }
        MutableQuad quad = this.helperMutableQuad;
        quad.fillFromBakedQuad(bakedQuad);
        float centerX = (quad.x(0) + quad.x(1) + quad.x(2) + quad.x(3)) / 4.0f;
        float centerZ = (quad.z(0) + quad.z(1) + quad.z(2) + quad.z(3)) / 4.0f;
        double quadDistance = Math.sqrt(((double)centerX - 0.5) * ((double)centerX - 0.5) + ((double)centerZ - 0.5) * ((double)centerZ - 0.5));
        if (quadDistance < 0.1) {
            return quadDirection == Direction.UP ? stateAbove == null : stateBelow == null;
        }
        Direction partSide = Direction.getApproximateNearest((double)((double)centerX - 0.5), (double)0.0, (double)((double)centerZ - 0.5));
        return quadDirection == Direction.UP ? stateAbove == null || !((Boolean)stateAbove.getValue((Property)SIDE_PROPERTIES[partSide.ordinal()])).booleanValue() : stateBelow == null || (Boolean)stateBelow.getValue((Property)SIDE_PROPERTIES[partSide.ordinal()]) == false;
    }

    @Override
    @Nullable
    public Object createGeometryKey(BlockAndTintGetter blockView, BlockPos pos, BlockState state, RandomSource random) {
        return Pair.of(this, super.createGeometryKey(blockView, pos, state, random));
    }

    private class FilteringModelPart
    implements BlockModelPart {
        private final BlockModelPart original;
        private final Pair<BlockState, BlockState> neighbors;

        private FilteringModelPart(BlockModelPart original, Pair<BlockState, BlockState> neighbors) {
            this.original = original;
            this.neighbors = neighbors;
        }

        public List<BakedQuad> getQuads(@Nullable Direction cullDirection) {
            return PaneCullingBakedModel.this.getQuads(this.original, this.neighbors, cullDirection);
        }

        public boolean useAmbientOcclusion() {
            return this.original.useAmbientOcclusion();
        }

        public TextureAtlasSprite particleIcon() {
            return this.original.particleIcon();
        }

        public RenderType getRenderType(BlockState state) {
            return this.original.getRenderType(state);
        }

        public TriState ambientOcclusion() {
            return this.original.ambientOcclusion();
        }
    }
}

