/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseBakedModel
implements BlockStateModel {
    private final Map<RenderType, List<TaggedBakedQuad>[]> blockMesh;
    private final List<RenderType> blockRenderTypes;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final TextureAtlasSprite particleIcon;

    public BaseBakedModel(List<BaseModelQuad> quads, boolean hasAmbientOcclusion, TextureAtlasSprite particleIcon, RenderType neoforgeRenderType) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.particleIcon = particleIcon;
        HashMap<RenderType, List[]> blockMesh = new HashMap<RenderType, List[]>();
        HashSet<RenderType> blockRenderTypes = new HashSet<RenderType>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        MutableQuad mutableQuad = new MutableQuad();
        for (BaseModelQuad quad : quads) {
            mutableQuad.fillFromBakedQuad(quad.bakedQuad());
            mutableQuad.ambientOcclusion(!quad.emissive() && hasAmbientOcclusion);
            mutableQuad.emissive(quad.emissive());
            int spriteIndex = -1;
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().sprite(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), quad.textureType(), spriteIndex);
            RenderType renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
            if (renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER && neoforgeRenderType != null) {
                renderType = neoforgeRenderType;
            }
            blockRenderTypes.add(renderType);
            int cullIndex = BaseBakedModel.cullIndex(quad.cullDirection());
            List[] mesh = blockMesh.computeIfAbsent(renderType, r -> new List[7]);
            if (mesh[cullIndex] == null) {
                mesh[cullIndex] = new ArrayList();
            }
            mesh[cullIndex].add(finishedQuad);
        }
        this.blockMesh = Map.copyOf(blockMesh);
        this.blockRenderTypes = List.copyOf(blockRenderTypes);
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
    }

    public void collectParts(final BlockAndTintGetter level, final BlockPos pos, final BlockState state, final RandomSource random, List<BlockModelPart> parts) {
        for (final RenderType renderType : this.blockRenderTypes) {
            parts.add(new BlockModelPart(){

                public List<BakedQuad> getQuads(@Nullable Direction cullDirection) {
                    return BaseBakedModel.this.getQuads(level, pos, state, cullDirection, random, renderType);
                }

                public boolean useAmbientOcclusion() {
                    return BaseBakedModel.this.hasAmbientOcclusion;
                }

                public TextureAtlasSprite particleIcon() {
                    return BaseBakedModel.this.particleIcon;
                }

                public RenderType getRenderType(BlockState state2) {
                    return renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? ItemBlockRenderTypes.getChunkRenderType((BlockState)state2) : renderType;
                }
            });
        }
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        this.collectParts(null, null, null, random, parts);
    }

    private List<BakedQuad> getQuads(@Nullable BlockAndTintGetter blockView, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction cullDirection, RandomSource random, @NotNull RenderType renderType) {
        List<TaggedBakedQuad> quads = this.blockMesh.get(renderType)[BaseBakedModel.cullIndex(cullDirection)];
        if (quads == null) {
            return Collections.emptyList();
        }
        if (!this.hasSpecialQuads) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        if (pos == null) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
        MutableQuad mutableQuad = new MutableQuad();
        for (TaggedBakedQuad quad : quads) {
            if (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS) {
                TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                if (quad.textureType == DefaultTextureTypes.RANDOM) {
                    RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.direction(), random, (RandomTextureSprite)sprite);
                } else {
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.direction(), (ContinuousTextureSprite)sprite);
                }
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            bakedQuads.add(quad.bakedQuad);
        }
        return bakedQuads;
    }

    @Nullable
    public Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
        return this.hasSpecialQuads ? Pair.of(this, pos) : this;
    }

    public TextureAtlasSprite particleIcon() {
        return this.particleIcon;
    }

    private static int cullIndex(Direction cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
        }
    }
}

