/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.js_furniture_mod.block.blockentity.client.CoffeeTableBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CoffeeTableBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HAS_ITEM = BooleanProperty.create((String)"has_item");
    private static final VoxelShape HORIZONTAL = Shapes.or((VoxelShape)Block.box((double)-2.5, (double)0.0, (double)2.25, (double)-1.25, (double)8.0, (double)3.5), (VoxelShape[])new VoxelShape[]{Block.box((double)17.25, (double)0.0, (double)2.25, (double)18.5, (double)8.0, (double)3.5), Block.box((double)17.25, (double)0.0, (double)12.5, (double)18.5, (double)8.0, (double)13.75), Block.box((double)-2.5, (double)0.0, (double)12.5, (double)-1.25, (double)8.0, (double)13.75), Block.box((double)-2.0, (double)4.625, (double)3.5, (double)8.0, (double)4.975, (double)12.5), Block.box((double)-2.5, (double)8.0, (double)2.25, (double)18.5, (double)9.25, (double)13.75), Block.box((double)8.0, (double)4.625, (double)3.5, (double)18.0, (double)4.975, (double)12.5)});
    private static final VoxelShape VERTICAL = Shapes.or((VoxelShape)Block.box((double)12.5, (double)0.0, (double)-2.5, (double)13.75, (double)8.0, (double)-1.25), (VoxelShape[])new VoxelShape[]{Block.box((double)12.5, (double)0.0, (double)17.25, (double)13.75, (double)8.0, (double)18.5), Block.box((double)2.25, (double)0.0, (double)17.25, (double)3.5, (double)8.0, (double)18.5), Block.box((double)2.25, (double)0.0, (double)-2.5, (double)3.5, (double)8.0, (double)-1.25), Block.box((double)3.5, (double)4.625, (double)-2.0, (double)12.5, (double)4.975, (double)8.0), Block.box((double)2.25, (double)8.0, (double)-2.5, (double)13.75, (double)9.25, (double)18.5), Block.box((double)3.5, (double)4.625, (double)8.0, (double)12.5, (double)4.975, (double)18.0)});

    public CoffeeTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> HORIZONTAL;
            case Direction.SOUTH -> HORIZONTAL;
            case Direction.EAST -> VERTICAL;
            case Direction.WEST -> VERTICAL;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_ITEM});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CoffeeTableBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        CoffeeTableBlockEntity be = (CoffeeTableBlockEntity)level.getBlockEntity(pos);
        ItemStack held = player.getMainHandItem();
        assert (be != null);
        if (be.getItem().isEmpty() && !held.isEmpty()) {
            ItemStack put = held.copy();
            put.setCount(1);
            be.setItem(put);
            held.shrink(1);
        } else if (!be.getItem().isEmpty()) {
            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)(pos.getY() + 1), (double)((double)pos.getZ() + 0.5), (ItemStack)be.getItem());
            be.setItem(ItemStack.EMPTY);
        }
        return InteractionResult.CONSUME;
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean moved) {
        if (state.getBlock() != state.getBlock()) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof CoffeeTableBlockEntity) {
                CoffeeTableBlockEntity ct = (CoffeeTableBlockEntity)be;
                ItemStack s = ct.getItem();
                NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
                items.set(0, (Object)s);
            }
            super.affectNeighborsAfterRemoval(state, level, pos, moved);
        } else {
            super.affectNeighborsAfterRemoval(state, level, pos, moved);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        CoffeeTableBlockEntity table;
        ItemStack s;
        BlockEntity be;
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof CoffeeTableBlockEntity && !(s = (table = (CoffeeTableBlockEntity)be).getItem()).isEmpty()) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)s);
            table.setItem(ItemStack.EMPTY);
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }
}

