/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.base.Suppliers;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import com.supermartijn642.fusion.model.types.connecting.OrientedMutableQuad;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10401;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10809;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ConnectingItemModel
implements class_10439 {
    private final List<class_10401> tints;
    private final class_10809 properties;
    private final Mesh mesh;
    private final Supplier<Vector3f[]> extents;

    public ConnectingItemModel(List<class_10401> tints, List<ConnectingModelQuad> quads, class_10809 properties) {
        this.tints = tints;
        this.properties = properties;
        this.extents = Suppliers.memoize(() -> class_10430.method_67990(quads.stream().map(BaseModelQuad::bakedQuad).toList()));
        MutableMesh builder = Renderer.get().mutableMesh();
        QuadEmitter emitter = builder.emitter();
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (ConnectingModelQuad quad : quads) {
            int auxiliaryQuadCount = 0;
            ConnectingTextureLayoutHandler layoutHandler = null;
            if (quad.hasConnectingTexture()) {
                layoutHandler = ConnectingTextureLayoutHandler.get(quad.getLayout());
                auxiliaryQuadCount = layoutHandler.getAuxiliaryQuadCount();
            }
            RenderMaterial material = FusionClient.getRenderTypeMaterial(null, quad.renderType(), quad.emissive());
            for (int quadIndex = 0; quadIndex < auxiliaryQuadCount + 1; ++quadIndex) {
                emitter.fromVanilla(quad.bakedQuad(), material, quad.cullDirection());
                if (layoutHandler != null) {
                    mutableQuad.set((MutableQuadView)emitter);
                    mutableQuad.set(ConnectingBakedModel.TextureOrientation.NORMAL_0.vertexIndexPermutation);
                    boolean keepQuad = layoutHandler.processItemQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)quad.bakedQuad().comp_3724());
                    if (!keepQuad) continue;
                }
                emitter.emit();
            }
        }
        this.mesh = builder.immutableCopy();
    }

    public void method_65584(class_10444 renderState, class_1799 stack, class_10442 modelResolver, class_811 displayContext, @Nullable class_638 level, @Nullable class_1309 entity, int i) {
        class_10444.class_10446 layer = renderState.method_65601();
        if (stack.method_7958()) {
            layer.method_65615(class_10430.method_65583((class_1799)stack) ? class_10444.class_10445.field_55343 : class_10444.class_10445.field_55342);
        }
        int tints = this.tints.size();
        int[] tintValues = layer.method_65613(tints);
        for (int j = 0; j < tints; ++j) {
            tintValues[j] = this.tints.get(j).method_65389(stack, level, entity);
        }
        layer.method_67995(this.extents);
        this.properties.method_68000(layer, displayContext);
        this.mesh.outputTo(layer.emitter());
        layer.method_67992(class_4722.method_29382());
    }
}

