/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.BlockModelBakingContext;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ItemModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingItemModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelDataImpl;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10439;
import net.minecraft.class_1058;
import net.minecraft.class_10809;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class ConnectingModelType
implements ModelType<ConnectingModelData> {
    public static final String DEFAULT_CONNECTION_KEY = "default";

    @Override
    public Collection<class_2960> getModelDependencies(ConnectingModelData data) {
        return DefaultModelTypes.VANILLA.getModelDependencies(data.getVanillaModel());
    }

    @Override
    @Nullable
    public class_1100 getAsVanillaModel(ConnectingModelData data) {
        return DefaultModelTypes.VANILLA.getAsVanillaModel(data.getVanillaModel());
    }

    @Override
    public List<class_2960> getParentModels(ConnectingModelData data) {
        return data.getParents();
    }

    @Override
    public class_1087 bakeBlockModel(BlockModelBakingContext context, ConnectingModelData data) {
        ((ConnectingModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((ConnectingModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)((Object)data)).findProperty(context, class_1100::comp_3741, true);
        class_1058 particleSprite = context.getTexture(((BaseModelDataImpl)((Object)data)).findParticleSprite(context));
        return new ConnectingBakedModel(quads, ambientOcclusion, particleSprite);
    }

    @Override
    public class_10439 bakeItemModel(ItemModelBakingContext context, ConnectingModelData data) {
        ((ConnectingModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((ConnectingModelDataImpl)data).bakeQuads(context);
        boolean usesBlockLight = ((BaseModelDataImpl)((Object)data)).findProperty((BlockModelBakingContext)context, class_1100::comp_3740, class_1100.class_4751.field_21859).method_24299();
        class_1058 particleSprite = context.getTexture(((BaseModelDataImpl)((Object)data)).findParticleSprite(context));
        class_809 transforms = new class_809(((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4323), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4320), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4321), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4322), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4316), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4317), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4318), ((BaseModelDataImpl)((Object)data)).findItemTransform(context, class_811.field_4319));
        return new ConnectingItemModel(context.getTintSources(), quads, new class_10809(usesBlockLight, particleSprite, transforms));
    }

    @Override
    public ConnectingModelData deserialize(JsonObject json) throws JsonParseException {
        BaseModelData base = (BaseModelData)DefaultModelTypes.BASE.deserialize(json);
        HashMap<String, ConnectionPredicate> predicates = new HashMap<String, ConnectionPredicate>();
        HashMap<String, String> connectionReferences = new HashMap<String, String>();
        predicates.put(DEFAULT_CONNECTION_KEY, DefaultConnectionPredicates.isSameState());
        if (json.has("connections")) {
            JsonElement connectionsElement = json.get("connections");
            if (connectionsElement.isJsonArray() || connectionsElement.isJsonObject() && connectionsElement.getAsJsonObject().has("type")) {
                predicates.put(DEFAULT_CONNECTION_KEY, ConnectingModelType.loadPredicate(connectionsElement, "connections"));
            } else if (connectionsElement.isJsonObject()) {
                JsonObject object = connectionsElement.getAsJsonObject();
                if (object.isEmpty()) {
                    throw new JsonParseException("Property 'connections' must have a 'type' key or keys per texture!");
                }
                for (String texture : object.keySet()) {
                    if (object.get(texture).isJsonPrimitive() && object.getAsJsonPrimitive(texture).isString()) {
                        connectionReferences.put(texture, object.get(texture).getAsString());
                        continue;
                    }
                    predicates.put(texture, ConnectingModelType.loadPredicate(object.get(texture), texture));
                }
            } else {
                throw new JsonParseException("Property 'connections' must be an array!");
            }
        }
        ArrayList<ConnectingModelElement> elements = new ArrayList<ConnectingModelElement>(((BaseModelDataImpl)base).getElements().size());
        JsonArray elementsJson = json.getAsJsonArray("elements");
        for (int i = 0; i < ((BaseModelDataImpl)base).getElements().size(); ++i) {
            JsonObject elementFaces = elementsJson.get(i).getAsJsonObject().getAsJsonObject("faces");
            BaseModelElement baseElement = ((BaseModelDataImpl)base).getElements().get(i);
            EnumMap<class_2350, String> connectionKeys = null;
            if (elementFaces != null) {
                for (class_2350 side : class_2350.values()) {
                    if (!elementFaces.has(side.method_10151()) || !elementFaces.get(side.method_10151()).isJsonObject() || !elementFaces.getAsJsonObject(side.method_10151()).has("connections")) continue;
                    JsonElement connectionsJson = elementFaces.getAsJsonObject(side.method_10151()).get("connections");
                    if (!connectionsJson.isJsonPrimitive() || !connectionsJson.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Face property 'connections' must be a string!");
                    }
                    String key = connectionsJson.getAsString();
                    if (key.isEmpty()) {
                        throw new JsonParseException("Face property 'connections' must not be empty!");
                    }
                    if (connectionKeys == null) {
                        connectionKeys = new EnumMap<class_2350, String>(class_2350.class);
                    }
                    connectionKeys.put(side, key);
                }
            }
            elements.add(new ConnectingModelElement(baseElement.comp_3727(), baseElement.comp_3728(), baseElement.comp_3729(), baseElement.comp_3730(), baseElement.comp_3731(), baseElement.comp_3732(), connectionKeys));
        }
        return new ConnectingModelDataImpl(base.getVanillaModel(), base.getParents(), elements, predicates, connectionReferences);
    }

    @Override
    public JsonObject serialize(ConnectingModelData value) {
        JsonObject json = DefaultModelTypes.BASE.serialize(value);
        Map<String, ConnectionPredicate> predicates = value.getAllConnectionPredicates();
        if (predicates.size() == 1 && predicates.containsKey(DEFAULT_CONNECTION_KEY)) {
            json.add("connections", (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicates.get(DEFAULT_CONNECTION_KEY)));
        } else if (!predicates.isEmpty()) {
            JsonObject connectionsJson = new JsonObject();
            predicates.forEach((texture, predicate) -> connectionsJson.add(texture, (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate)));
            json.add("connections", (JsonElement)connectionsJson);
        }
        for (int i = 0; i < ((ConnectingModelDataImpl)value).getElements().size(); ++i) {
            JsonObject elementFaces;
            Map<class_2350, String> connectionKeys = ((ConnectingModelDataImpl)value).getElements().get((int)i).faceConnectionKeys;
            if (connectionKeys.isEmpty() || (elementFaces = json.getAsJsonArray("elements").get(i).getAsJsonObject().getAsJsonObject("faces")) == null) continue;
            for (class_2350 side : connectionKeys.keySet()) {
                if (!elementFaces.has(side.method_10151())) continue;
                elementFaces.getAsJsonObject(side.method_10151()).addProperty("connections", connectionKeys.get(side));
            }
        }
        return json;
    }

    private static ConnectionPredicate loadPredicate(JsonElement element, String key) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<ConnectionPredicate> subPredicates = new ArrayList<ConnectionPredicate>();
            for (JsonElement predicateElements : array) {
                if (!predicateElements.isJsonObject()) {
                    throw new JsonParseException("Predicate '" + key + "' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(predicateElements.getAsJsonObject());
                subPredicates.add(predicate);
            }
            return DefaultConnectionPredicates.or((ConnectionPredicate[])subPredicates.toArray(ConnectionPredicate[]::new));
        }
        if (element.isJsonObject()) {
            return FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
        }
        throw new JsonParseException("Predicate '" + key + "' must be an object or an array!");
    }
}

