/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.model.ItemBakedModel;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseBakedModel
implements BakedModel {
    public static final ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();
    private final List<TaggedBakedQuad>[] completeBlockMesh;
    private final List<BakedQuad> completeItemMesh;
    private final Map<RenderType, List<TaggedBakedQuad>[]> blockMesh;
    private final Map<RenderType, List<BakedQuad>> itemMesh;
    private final ChunkRenderTypeSet blockRenderTypes;
    private final boolean shouldCheckOriginalBlockRenderTypes;
    private final List<BakedModel> itemModels;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final TextureAtlasSprite particleIcon;
    private final ItemTransforms transforms;

    public BaseBakedModel(List<BaseModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particleIcon, ItemTransforms transforms, RenderType neoforgeRenderType) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        HashMap<RenderType, List[]> blockMesh = new HashMap<RenderType, List[]>();
        HashSet<RenderType> blockRenderTypes = new HashSet<RenderType>();
        HashMap<RenderType, List> itemMesh = new HashMap<RenderType, List>();
        LinkedHashSet<RenderType> itemRenderTypes = new LinkedHashSet<RenderType>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        MutableQuad mutableQuad = new MutableQuad();
        for (BaseModelQuad quad : quads) {
            mutableQuad.fillFromBakedQuad(quad.bakedQuad());
            mutableQuad.ambientOcclusion(!quad.emissive() && hasAmbientOcclusion);
            mutableQuad.emissive(quad.emissive());
            int spriteIndex = -1;
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().getSprite(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), quad.textureType(), spriteIndex);
            RenderType renderType2 = FusionClient.getRenderTypeMaterial(quad.renderType());
            if (renderType2 == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER && neoforgeRenderType != null) {
                renderType2 = neoforgeRenderType;
            }
            blockRenderTypes.add(renderType2);
            int cullIndex = BaseBakedModel.cullIndex(quad.cullDirection());
            List[] mesh = blockMesh.computeIfAbsent(renderType2, r -> new List[7]);
            if (mesh[cullIndex] == null) {
                mesh[cullIndex] = new ArrayList();
            }
            mesh[cullIndex].add(finishedQuad);
            RenderType itemRenderType = renderType2 == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER : RenderTypeHelper.getEntityRenderType((RenderType)renderType2);
            itemRenderTypes.add(itemRenderType);
            List itemQuads = itemMesh.computeIfAbsent(itemRenderType, k -> new ArrayList());
            itemQuads.add(mutableQuad.toBakedQuad());
        }
        this.blockMesh = Map.copyOf(blockMesh);
        this.blockRenderTypes = ChunkRenderTypeSet.of(blockRenderTypes.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).toList());
        this.shouldCheckOriginalBlockRenderTypes = blockRenderTypes.contains(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
        this.itemMesh = Map.copyOf(itemMesh);
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
        this.completeBlockMesh = new List[7];
        for (int i = 0; i < 7; ++i) {
            int cullIndex = i;
            this.completeBlockMesh[i] = this.blockMesh.values().stream().map(arr -> arr[cullIndex]).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        }
        this.completeItemMesh = itemRenderTypes.stream().map(this.itemMesh::get).flatMap(Collection::stream).toList();
        this.itemModels = itemRenderTypes.stream().map(renderType -> new ItemBakedModel(this, (RenderType)renderType){
            final /* synthetic */ RenderType val$renderType;
            {
                this.val$renderType = renderType;
                super(original);
            }

            @Override
            protected List<BakedQuad> getQuads(ItemStack stack, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType rt) {
                if (rt == null) {
                    return BaseBakedModel.this.completeItemMesh;
                }
                List<BakedQuad> quads = BaseBakedModel.this.itemMesh.get(this.val$renderType);
                return quads == null ? Collections.emptyList() : quads;
            }

            @Override
            public RenderType getRenderType(ItemStack stack) {
                return this.val$renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? 1.getNonModelRenderType(stack) : this.val$renderType;
            }
        }).toList();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> bakedQuads;
        ArrayList<TaggedBakedQuad> quads;
        if (renderType == null) {
            quads = this.completeBlockMesh[BaseBakedModel.cullIndex(cullDirection)];
        } else {
            List<TaggedBakedQuad>[] mesh = this.blockMesh.get(renderType);
            List<TaggedBakedQuad> list = quads = mesh == null ? null : mesh[BaseBakedModel.cullIndex(cullDirection)];
            if (this.shouldCheckOriginalBlockRenderTypes && state != null && ItemBlockRenderTypes.getRenderLayers((BlockState)state).contains(renderType)) {
                Iterator<TaggedBakedQuad> additionalQuads;
                mesh = this.blockMesh.get(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
                Iterator<TaggedBakedQuad> iterator = additionalQuads = mesh == null ? null : mesh[BaseBakedModel.cullIndex(cullDirection)];
                if (additionalQuads != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList<TaggedBakedQuad> arrayList = new ArrayList<TaggedBakedQuad>(quads.size() + additionalQuads.size());
                        arrayList.addAll(quads);
                        arrayList.addAll((Collection<TaggedBakedQuad>)((Object)additionalQuads));
                        quads = arrayList;
                    }
                }
            }
            if (quads == null) {
                quads = Collections.emptyList();
            }
        }
        if (!this.hasSpecialQuads) {
            ArrayList<BakedQuad> bakedQuads2 = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad taggedBakedQuad : quads) {
                bakedQuads2.add(taggedBakedQuad.bakedQuad);
            }
            return bakedQuads2;
        }
        BlockPos pos = (BlockPos)data.get(POSITION_PROPERTY);
        if (pos == null) {
            bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        bakedQuads = new ArrayList(quads.size());
        MutableQuad mutableQuad = new MutableQuad();
        for (TaggedBakedQuad quad : quads) {
            if (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS) {
                TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                if (quad.textureType == DefaultTextureTypes.RANDOM) {
                    RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.getDirection(), random, (RandomTextureSprite)sprite);
                } else {
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.getDirection(), (ContinuousTextureSprite)sprite);
                }
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            bakedQuads.add(quad.bakedQuad);
        }
        return bakedQuads;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        return this.getQuads(state, side, random, ModelData.EMPTY, null);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (this.shouldCheckOriginalBlockRenderTypes) {
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ItemBlockRenderTypes.getRenderLayers((BlockState)state), this.blockRenderTypes});
        }
        return this.blockRenderTypes;
    }

    public RenderType getRenderType(ItemStack stack) {
        return Sheets.translucentItemSheet();
    }

    public List<BakedModel> getRenderPasses(ItemStack stack) {
        this.itemModels.forEach(model -> ((ItemBakedModel)model).set(stack));
        return this.itemModels;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        if (!this.hasSpecialQuads) {
            return ModelData.EMPTY;
        }
        return ModelData.builder().with(POSITION_PROPERTY, (Object)pos).build();
    }

    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    private static int cullIndex(Direction cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
        }
    }
}

