/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.model.FusionBlockModel;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_809;

public class ModelBakingContextImpl
implements ModelBakingContext {
    private final class_7775 modelBaker;
    private final Function<class_4730, class_1058> spriteGetter;
    private final class_3665 modelState;
    private final class_2960 modelIdentifier;
    private final Map<class_2960, class_1100> dependencies;
    private final Map<String, class_4730> topLevelTextureReferences;
    private final boolean topLevelAmbientOcclusion;
    private final boolean topLevelUseBlockLighting;
    private final class_809 topLevelItemTransforms;

    public ModelBakingContextImpl(class_7775 modelBaker, Function<class_4730, class_1058> spriteGetter, class_3665 modelState, class_2960 modelIdentifier, Map<class_2960, class_1100> dependencies, Map<String, class_4730> topLevelTextureReferences, boolean topLevelAmbientOcclusion, boolean topLevelUseBlockLighting, class_809 topLevelItemTransforms) {
        this.modelBaker = modelBaker;
        this.spriteGetter = spriteGetter;
        this.modelState = modelState;
        this.modelIdentifier = modelIdentifier;
        this.dependencies = dependencies;
        this.topLevelTextureReferences = topLevelTextureReferences;
        this.topLevelAmbientOcclusion = topLevelAmbientOcclusion;
        this.topLevelUseBlockLighting = topLevelUseBlockLighting;
        this.topLevelItemTransforms = topLevelItemTransforms;
    }

    @Override
    public class_7775 getModelBaker() {
        return this.modelBaker;
    }

    @Override
    public class_1058 getTexture(SpriteIdentifier identifier) {
        return this.spriteGetter.apply(identifier.toMaterial());
    }

    @Override
    public class_1058 getTexture(class_2960 atlas, class_2960 texture) {
        return this.spriteGetter.apply(new class_4730(atlas, texture));
    }

    @Override
    public class_3665 getTransformation() {
        return this.modelState;
    }

    @Override
    public class_2960 getModelIdentifier() {
        return this.modelIdentifier;
    }

    @Override
    public ModelInstance<?> getModel(class_2960 identifier) {
        if (!this.dependencies.containsKey(identifier)) {
            throw new IllegalStateException("Requesting model that was not given as a dependency!");
        }
        return FusionBlockModel.getModelInstance(this.dependencies.get(identifier));
    }

    @Override
    public Map<String, class_4730> getTopLevelTextureReferences() {
        return this.topLevelTextureReferences;
    }

    @Override
    public boolean getTopLevelAmbientOcclusion() {
        return this.topLevelAmbientOcclusion;
    }

    @Override
    public boolean getTopLevelUseBlockLighting() {
        return this.topLevelUseBlockLighting;
    }

    @Override
    public class_809 getTopLevelItemTransforms() {
        return this.topLevelItemTransforms;
    }
}

