/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.ItemModelModifierItemModel;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10526;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3665;
import net.minecraft.class_4309;
import net.minecraft.class_7654;
import net.minecraft.class_7923;

public class ItemModelModifierReloadListener {
    private static final String LOCATION = "fusion/model_modifiers/items";
    private static final class_7654 ID_CONVERTER = class_7654.method_45114((String)"fusion/model_modifiers/items");
    public static final ItemModelModifierReloadListener INSTANCE = new ItemModelModifierReloadListener();
    private final Map<class_2960, ItemModelPredicatesProperties> models = new HashMap<class_2960, ItemModelPredicatesProperties>();

    private ItemModelModifierReloadListener() {
    }

    public void registerPredicateModels(class_10526.class_10103 resolver) {
        HashSet<class_2960> models = new HashSet<class_2960>();
        for (ItemModelPredicatesProperties properties : this.models.values()) {
            models.addAll(properties.dependencies());
        }
        models.forEach(arg_0 -> ((class_10526.class_10103)resolver).method_62642(arg_0));
    }

    public void applyPredicateModels(class_1088.class_10524 results, class_1088.class_7778 resolver) {
        Map bakedModels = results.comp_3432();
        for (Map.Entry<class_2960, ItemModelPredicatesProperties> entry : this.models.entrySet()) {
            class_2960 target = entry.getKey();
            ItemModelPredicatesProperties properties = entry.getValue();
            if (!bakedModels.containsKey(target)) continue;
            class_10430 defaultModel = properties.defaultModel == null ? (class_10439)bakedModels.get(target) : new class_10430(resolver.method_45873(properties.defaultModel, (class_3665)class_1086.field_5350), List.of());
            List<com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_1087>> models = properties.models.stream().map(pair -> pair.mapRight(location -> resolver.method_45873(location, (class_3665)class_1086.field_5350))).toList();
            bakedModels.put(target, new ItemModelModifierItemModel((class_10439)defaultModel, models));
        }
    }

    public void reload(class_3300 resourceManager) {
        ItemPredicateRegistry.finalizeRegistration();
        this.models.clear();
        HashMap resources = new HashMap();
        class_4309.method_51148((class_3300)resourceManager, (class_7654)ID_CONVERTER, (DynamicOps)JsonOps.INSTANCE, (Codec)new Codec<JsonElement>(this){

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
            }
        }, resources);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Item model predicates file '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse item model predicates file '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet<class_2960> targets = new HashSet<class_2960>();
        for (JsonElement element : targetsJson) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Array property 'targets' must only contain strings!");
            }
            if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
            }
            class_2960 identifier = class_2960.method_60654((String)element.getAsString());
            Optional item = class_7923.field_41178.method_17966(identifier);
            if (item.isEmpty()) {
                throw new JsonParseException("Could not find an item for target '" + String.valueOf(identifier) + "'!");
            }
            targets.add(identifier);
        }
        if (targets.isEmpty()) {
            return;
        }
        class_2960 defaultModel = null;
        if (json.has("default_model")) {
            if (!json.get("default_model").isJsonPrimitive() || !json.getAsJsonPrimitive("default_model").isString()) {
                throw new JsonParseException("Property 'default_model' must be a string!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("default_model").getAsString())) {
                throw new JsonParseException("Default model must be a valid identifier, not '" + json.get("default_model").getAsString() + "'!");
            }
            defaultModel = class_2960.method_60654((String)json.get("default_model").getAsString());
        }
        if (!json.has("models") || !json.get("models").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'models'!");
        }
        JsonArray modelsJson = json.getAsJsonArray("models");
        ArrayList<com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_2960>> models = new ArrayList<com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_2960>>();
        for (JsonElement element : modelsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Array property 'models' must only contain objects!");
            }
            models.add(this.parseModelEntry(element.getAsJsonObject()));
        }
        if (defaultModel == null && models.isEmpty()) {
            return;
        }
        ItemModelPredicatesProperties properties = new ItemModelPredicatesProperties(defaultModel, models);
        for (class_2960 target : targets) {
            this.models.put(target, properties);
        }
    }

    private com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_2960> parseModelEntry(JsonObject json) {
        if (!(json.has("model") && json.get("model").isJsonPrimitive() && json.getAsJsonPrimitive("model").isString())) {
            throw new JsonParseException("Models entry must have string property 'model'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("model").getAsString())) {
            throw new JsonParseException("Model must be a valid identifier, not '" + json.get("model").getAsString() + "'!");
        }
        class_2960 model = class_2960.method_60654((String)json.get("model").getAsString());
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new JsonParseException("Models entry must have array property 'conditions'!");
        }
        JsonArray conditionsJson = json.getAsJsonArray("conditions");
        if (conditionsJson.isEmpty()) {
            throw new JsonParseException("Model entry property 'conditions' must not be empty!");
        }
        ArrayList<ItemPredicate> predicates = new ArrayList<ItemPredicate>();
        for (JsonElement element : conditionsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Model entry property 'conditions' must only contain objects!");
            }
            predicates.add(ItemPredicateRegistry.deserializeItemPredicate(element.getAsJsonObject()));
        }
        ItemPredicate predicate = predicates.size() == 1 ? (ItemPredicate)predicates.getFirst() : new AndItemPredicate(predicates);
        return com.supermartijn642.fusion.api.util.Pair.of(predicate, model);
    }

    private static class ItemModelPredicatesProperties {
        final class_2960 defaultModel;
        final List<com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_2960>> models;

        private ItemModelPredicatesProperties(class_2960 defaultModel, List<com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_2960>> models) {
            this.defaultModel = defaultModel;
            this.models = models;
        }

        Collection<class_2960> dependencies() {
            HashSet<class_2960> models = new HashSet<class_2960>(this.models.size() + 1);
            if (this.defaultModel != null) {
                models.add(this.defaultModel);
            }
            for (com.supermartijn642.fusion.api.util.Pair<ItemPredicate, class_2960> entry : this.models) {
                models.add(entry.right());
            }
            return models;
        }
    }
}

