/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class PotionItemPredicate
implements ItemPredicate {
    public static final Serializer<PotionItemPredicate> SERIALIZER = new Serializer<PotionItemPredicate>(){

        @Override
        public PotionItemPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("potion") && json.get("potion").isJsonPrimitive() && json.getAsJsonPrimitive("potion").isString())) {
                throw new JsonParseException("Potion-predicate must have string property 'enchantment'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("potion").getAsString())) {
                throw new JsonParseException("Property 'enchantment' must be a valid identifier, not '" + json.get("potion").getAsString() + "'!");
            }
            class_2960 potionIdentifier = class_2960.method_60654((String)json.get("potion").getAsString());
            Optional potion = class_7923.field_41179.method_10223(potionIdentifier);
            if (potion.isEmpty()) {
                throw new JsonParseException("Unknown potion '" + String.valueOf(potionIdentifier) + "'!");
            }
            return new PotionItemPredicate((class_6880<class_1842>)((class_6880)potion.get()));
        }

        @Override
        public JsonObject serialize(PotionItemPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("potion", ((class_5321)value.potion.method_40230().get()).method_29177().toString());
            return json;
        }
    };
    private final class_6880<class_1842> potion;

    public PotionItemPredicate(class_6880<class_1842> potion) {
        if (potion == null) {
            throw new NullPointerException("Potion must not be null!");
        }
        this.potion = potion;
    }

    @Override
    public boolean test(class_1799 stack) {
        class_1844 potion = (class_1844)stack.method_57824(class_9334.field_49651);
        return potion != null && potion.method_57401(this.potion);
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

