/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_10419;
import net.minecraft.class_1058;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_789;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_801;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BaseModelDataImpl
implements BaseModelData {
    protected final class_793 model;
    protected final List<class_2960> parents;
    protected final List<BaseModelElement> elements;

    public BaseModelDataImpl(class_793 model, List<class_2960> parents, List<BaseModelElement> elements) {
        this.model = model;
        this.parents = ImmutableList.copyOf(parents);
        this.elements = ImmutableList.copyOf(elements);
    }

    @Override
    public class_793 getVanillaModel() {
        return this.model;
    }

    @Override
    public List<class_2960> getParents() {
        return this.parents;
    }

    public List<? extends BaseModelElement> getElements() {
        return this.elements;
    }

    public void validateParents(ModelBakingContext context) {
        ArrayList<class_2960> encounteredModels = new ArrayList<class_2960>();
        for (class_2960 parent : this.parents) {
            this.validateParents(context, parent, encounteredModels);
        }
    }

    private void validateParents(ModelBakingContext context, class_2960 modelLocation, List<class_2960> encounteredModels) {
        if (encounteredModels.contains(modelLocation)) {
            throw new IllegalStateException("Unable to bake model '" + String.valueOf(context.getModelIdentifier()) + "' due to circular dependency " + encounteredModels.stream().map(o -> "'" + String.valueOf(o) + "'").collect(Collectors.joining("->")) + "->'" + String.valueOf(modelLocation) + "'!");
        }
        encounteredModels.add(modelLocation);
        ModelInstance<?> model = context.getModel(modelLocation);
        if (model != null) {
            for (class_2960 dependency : model.getParentModels()) {
                this.validateParents(context, dependency, encounteredModels);
            }
        }
        encounteredModels.remove(encounteredModels.size() - 1);
    }

    public <T> T findProperty(ModelBakingContext context, Function<class_1100, T> property, T defaultValue) {
        T value = this.findProperty(context, ModelInstance.of(DefaultModelTypes.BASE, this), property);
        return value == null ? defaultValue : value;
    }

    private <T> T findProperty(ModelBakingContext context, ModelInstance<?> model, Function<class_1100, T> property) {
        T value;
        class_1100 vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (value = property.apply(vanillaModel)) != null) {
            return value;
        }
        for (class_2960 location : model.getParentModels()) {
            T childValue;
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null || (childValue = this.findProperty(context, dependency, property)) == null) continue;
            return childValue;
        }
        return null;
    }

    public class_804 findItemTransform(ModelBakingContext context, class_811 transformType) {
        return this.findProperty(context, (class_1100 model) -> {
            class_809 transforms = model.method_65540();
            if (transforms == null || transforms.method_3503(transformType) == class_804.field_4284) {
                return null;
            }
            return transforms.method_3503(transformType);
        }, class_804.field_4284);
    }

    public SpriteIdentifier findParticleSprite(ModelBakingContext context) {
        ModelInstance<BaseModelDataImpl> model = ModelInstance.of(DefaultModelTypes.BASE, this);
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add("particle");
        String currentKey = "particle";
        String finalCurrentKey;
        class_10419.class_10424 contents;
        while ((contents = this.findProperty(context, model, arg_0 -> BaseModelDataImpl.lambda$findParticleSprite$2(finalCurrentKey = currentKey, arg_0))) != null) {
            if (contents instanceof class_10419.class_10425) {
                return SpriteIdentifier.of(((class_10419.class_10425)contents).comp_3378());
            }
            currentKey = ((class_10419.class_10422)contents).comp_3377();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
        return SpriteIdentifier.missing();
    }

    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            class_1100 vanillaModel = model.getAsVanillaModel();
            if (vanillaModel instanceof class_801) {
                elements = this.generateItemModel(context, modelStack, (class_801)vanillaModel);
            } else if (vanillaModel instanceof class_793) {
                elements = ((class_793)vanillaModel).field_4245;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (class_785 element : elements) {
                for (class_2350 direction : element.field_4230.keySet()) {
                    class_783 face = (class_783)element.field_4230.get(direction);
                    class_1058 sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.comp_2869()));
                    class_777 quad = class_796.method_3468((Vector3f)element.field_4228, (Vector3f)element.field_4231, (class_783)face, (class_1058)sprite, (class_2350)direction, (class_3665)context.getTransformation(), (class_789)element.field_4232, (boolean)element.field_4229, (int)element.field_53159);
                    class_2350 cullDirection = face.comp_2867() != null ? class_2350.method_23225((Matrix4f)context.getTransformation().method_3509().method_22936(), (class_2350)face.comp_2867()) : null;
                    output.accept(new BaseModelQuad(quad, cullDirection));
                }
            }
            modelStack.pop();
            return;
        }
        for (class_2960 location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    protected SpriteIdentifier resolveMaterial(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            ModelInstance<?> model2;
            class_1100 vanillaModel;
            class_10419.class_10424 contents = null;
            Iterator<ModelInstance<?>> iterator = modelStack.iterator();
            while (iterator.hasNext() && ((vanillaModel = (model2 = iterator.next()).getAsVanillaModel()) == null || (contents = (class_10419.class_10424)vanillaModel.method_65539().comp_3376().get(currentKey)) == null)) {
            }
            if (contents == null) {
                String finalCurrentKey = currentKey;
                contents = this.findProperty(context, modelStack.getLast(), model -> (class_10419.class_10424)model.method_65539().comp_3376().get(finalCurrentKey));
            }
            if (contents == null) {
                return SpriteIdentifier.missing();
            }
            if (contents instanceof class_10419.class_10425) {
                return SpriteIdentifier.of(((class_10419.class_10425)contents).comp_3378());
            }
            currentKey = ((class_10419.class_10422)contents).comp_3377();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    protected List<class_785> generateItemModel(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, class_801 generator) {
        ArrayList<class_785> elements = new ArrayList<class_785>();
        for (int layer = 0; layer < class_801.field_4270.size(); ++layer) {
            String layerName = (String)class_801.field_4270.get(layer);
            SpriteIdentifier sprite = this.resolveMaterial(context, modelStack, layerName);
            if (SpriteIdentifier.missing().equals(sprite)) break;
            class_7764 spriteContents = context.getTexture(sprite).method_45851();
            elements.addAll(generator.method_3480(layer, layerName, spriteContents));
        }
        return elements;
    }

    private static /* synthetic */ class_10419.class_10424 lambda$findParticleSprite$2(String finalCurrentKey, class_1100 m) {
        return (class_10419.class_10424)m.method_65539().comp_3376().get(finalCurrentKey);
    }
}

