/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block.blockentity.client;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nhatjs.js_furniture_mod.block.CoffeeTableBlock;
import net.nhatjs.js_furniture_mod.block.blockentity.ModBlockEntities;

public class CoffeeTableBlockEntity
extends BlockEntity {
    private ItemStack stack = ItemStack.EMPTY;
    private int renderNonce = 0;

    public CoffeeTableBlockEntity(BlockPos pos, BlockState s) {
        super(ModBlockEntities.COFFEE_TABLE.get(), pos, s);
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public int getRenderNonce() {
        return this.renderNonce;
    }

    public void setItem(ItemStack s) {
        this.stack = s == null ? ItemStack.EMPTY : s;
        ++this.renderNonce;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CoffeeTableBlock.HAS_ITEM, (Comparable)Boolean.valueOf(!this.stack.isEmpty())), 3);
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider register) {
        super.saveAdditional(nbt, register);
        if (!this.stack.isEmpty()) {
            nbt.put("it", this.stack.save((HolderLookup.Provider)this.level.registryAccess()));
        }
        nbt.putInt("rn", this.renderNonce);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider register) {
        super.loadAdditional(nbt, register);
        this.stack = nbt.contains("it") ? ItemStack.parse((HolderLookup.Provider)this.level.registryAccess(), (Tag)nbt.getCompound("it")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.renderNonce = nbt.getInt("rn");
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider register) {
        return this.saveWithoutMetadata((HolderLookup.Provider)this.level.registryAccess());
    }
}

