/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_10101;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import net.minecraft.class_804;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<class_2960> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    @Nullable
    public class_793 getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<class_2960> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public class_1087 bake(ModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4244, true);
        boolean isGui3d = ((BaseModelDataImpl)data).findProperty(context, model -> model == class_10101.field_53679 ? Boolean.valueOf(false) : null, true);
        boolean usesBlockLight = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_21857, class_793.class_4751.field_21859).method_24299();
        class_1058 particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        class_804 transformThirdPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4323) ? model.field_4250.method_3503(class_811.field_4323) : null, class_804.field_4284);
        class_804 transformThirdPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4320) ? model.field_4250.method_3503(class_811.field_4320) : null, class_804.field_4284);
        class_804 transformFirstPersonLeftHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4321) ? model.field_4250.method_3503(class_811.field_4321) : null, class_804.field_4284);
        class_804 transformFirstPersonRightHand = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4322) ? model.field_4250.method_3503(class_811.field_4322) : null, class_804.field_4284);
        class_804 transformHead = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4316) ? model.field_4250.method_3503(class_811.field_4316) : null, class_804.field_4284);
        class_804 transformGui = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4317) ? model.field_4250.method_3503(class_811.field_4317) : null, class_804.field_4284);
        class_804 transformGround = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4318) ? model.field_4250.method_3503(class_811.field_4318) : null, class_804.field_4284);
        class_804 transformFixed = ((BaseModelDataImpl)data).findProperty(context, model -> model.field_4250.method_3501(class_811.field_4319) ? model.field_4250.method_3503(class_811.field_4319) : null, class_804.field_4284);
        class_809 itemTransforms = new class_809(transformThirdPersonLeftHand, transformThirdPersonRightHand, transformFirstPersonLeftHand, transformFirstPersonRightHand, transformHead, transformGui, transformGround, transformFixed);
        class_806 itemOverrides = data.getVanillaModel().field_4255.isEmpty() ? class_806.field_4292 : new class_806(context.getModelBaker(), data.getVanillaModel().field_4255);
        return new BaseBakedModel(quads, ambientOcclusion, isGui3d, usesBlockLight, particleSprite, itemTransforms, itemOverrides);
    }

    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        class_793 model = (class_793)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<class_2960> parents = List.of();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = List.of(class_2960.method_60654((String)parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList(parentArray.size());
            for (JsonElement element2 : parentArray) {
                if (!element2.isJsonPrimitive() || !element2.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element2.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(class_2960.method_60654((String)parent));
            }
            if (!parents.isEmpty()) {
                model.field_4247 = parents.get(0);
            }
        }
        ArrayList<BaseModelElement> elements = new ArrayList<BaseModelElement>(model.field_4245.size());
        model.field_4245.forEach(element -> elements.add(new BaseModelElement(element.field_4228, element.field_4231, element.field_4230, element.field_4232, element.field_4229, element.field_53159)));
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray(value.getParents().size());
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        return json;
    }
}

