/*
 * Decompiled with CFR 0.152.
 */
package net.nhatjs.js_furniture_mod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nhatjs.js_furniture_mod.block.ModBlocks;

public class PortableLaptopStandAddedBlock
extends Block {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty TURN_ON = BooleanProperty.create((String)"turn_on");
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public PortableLaptopStandAddedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)TURN_ON, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TURN_ON, OPEN});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Block.box((double)1.95, (double)0.0, (double)3.5, (double)14.05, (double)4.45, (double)12.5);
            case Direction.SOUTH -> Block.box((double)1.95, (double)0.0, (double)3.5, (double)14.05, (double)4.45, (double)12.5);
            case Direction.EAST -> Block.box((double)3.5, (double)0.0, (double)1.95, (double)12.5, (double)4.45, (double)14.05);
            case Direction.WEST -> Block.box((double)3.5, (double)0.0, (double)1.95, (double)12.5, (double)4.45, (double)14.05);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean turnOn = (Boolean)state.getValue((Property)TURN_ON);
        double x = hit.getBlockPos().getX();
        double y = hit.getBlockPos().getY();
        double z = hit.getBlockPos().getZ();
        if (player.isShiftKeyDown()) {
            if (!open) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
                return InteractionResult.CONSUME;
            }
            if (open) {
                if (turnOn) {
                    return InteractionResult.CONSUME;
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.CONSUME;
        }
        if (!player.isShiftKeyDown() && !open && player.getMainHandItem().isEmpty()) {
            Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            level.setBlock(pos, (BlockState)((Block)ModBlocks.PORTABLE_LAPTOP_STAND.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing), 3);
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, x, y, z, new ItemStack((ItemLike)ModBlocks.LAPTOP.get()));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
            return InteractionResult.SUCCESS;
        }
        if (open) {
            if (!turnOn) {
                level.setBlock(pos, (BlockState)state.setValue((Property)TURN_ON, (Comparable)Boolean.valueOf(true)), 3);
                return InteractionResult.CONSUME;
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)TURN_ON, (Comparable)Boolean.valueOf(false)), 3);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }
}

