/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.item;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.geo.renderer.SharedShieldRenderer;
import com.henrique.punchy.item.AnimatedTool;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10707;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.KeyFrameEvent;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;

public class AnimatedShield
extends AnimatedTool {
    private static final class_2960 REGISTRY_ID = class_2960.method_60655((String)"punchy", (String)"animated_shield");
    private static final Map<class_1268, BlockAnimationState> BLOCK_STATES = new EnumMap<class_1268, BlockAnimationState>(class_1268.class);
    private static final String RAISE_RIGHT = "animation.shield_animated.rise";
    private static final String RAISE_LEFT = "animation.shield_animated.rise_left";
    private static final String BLOCK_TRIGGER_RIGHT = "shield_block_right";
    private static final String BLOCK_TRIGGER_LEFT = "shield_block_left";

    private static AnimationController<?> getActivationController(BlockAnimationState state) {
        if (state == null) {
            return null;
        }
        AnimatableInstanceCache cache = state.item.getAnimatableInstanceCache();
        if (cache == null) {
            return null;
        }
        AnimatableManager manager = cache.getManagerForId(state.animationId);
        if (manager == null) {
            return null;
        }
        return (AnimationController)manager.getAnimationControllers().get("Activation");
    }

    public static void beginBlocking(class_1657 player, class_1268 hand, class_1799 stack) {
        class_1268 effectiveHand;
        class_1792 class_17922;
        if (stack == null || stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof AnimatedShield)) {
            return;
        }
        AnimatedShield shield = (AnimatedShield)class_17922;
        class_1268 class_12682 = effectiveHand = hand == null ? class_1268.field_5808 : hand;
        if (effectiveHand == class_1268.field_5808) {
            return;
        }
        AnimatedTool.markNextActionHand(effectiveHand);
        long id = GeoItem.getId((class_1799)stack);
        BlockAnimationState state = new BlockAnimationState(shield, id, -1.0);
        BLOCK_STATES.put(effectiveHand, state);
        AnimationController<?> controller = AnimatedShield.getActivationController(state);
        String trigger = AnimatedShield.activationTriggerForHand(effectiveHand);
        String clip = AnimatedShield.raiseClipForHand(effectiveHand);
        if (controller != null) {
            controller.forceAnimationReset();
            controller.setAnimationState(AnimationController.State.RUNNING);
            controller.tryTriggerAnimation(trigger);
        }
        ((GeoItem)stack.method_7909()).triggerAnim((class_1297)player, id, "Activation", trigger);
    }

    public static void tickBlocking(class_1657 player, class_1268 hand) {
        double lastLogged;
        BlockAnimationState state = BLOCK_STATES.get(hand);
        if (state == null) {
            return;
        }
        AnimationController<?> controller = AnimatedShield.getActivationController(state);
        if (controller == null) {
            return;
        }
        if (controller.getCurrentRawAnimation() == null) {
            return;
        }
        double seconds = controller.getCurrentAnimationSeconds();
        if (Math.abs(seconds - (lastLogged = state.lastLoggedSeconds())) >= 0.05) {
            BLOCK_STATES.put(hand, new BlockAnimationState(state.item(), state.animationId(), seconds));
        }
    }

    public static void endBlocking(class_1657 player, class_1268 hand) {
        BlockAnimationState state = BLOCK_STATES.remove(hand);
        if (state == null) {
            return;
        }
        AnimationController<?> controller = AnimatedShield.getActivationController(state);
        String trigger = AnimatedShield.activationTriggerForHand(hand);
        state.item().stopTriggeredAnim((class_1297)player, state.animationId(), "Activation", trigger);
        if (controller != null) {
            controller.forceAnimationReset();
            controller.setAnimationState(AnimationController.State.STOPPED);
        }
    }

    public AnimatedShield() {
        super(new class_1792.class_1793().method_7889(1).method_7895(336).method_57349(class_9334.field_49619, (Object)class_9307.field_49404).method_61647(class_3489.field_52381).method_64194(class_1304.field_6171).method_57349(class_9334.field_56396, (Object)new class_10707(0.25f, 1.0f, List.of(new class_10707.class_10708(90.0f, Optional.empty(), 0.0f, 1.0f)), new class_10707.class_10709(3.0f, 1.0f, 1.0f), Optional.of(class_8103.field_56242), Optional.of(class_3417.field_15150), Optional.of(class_3417.field_15239))).method_57349(class_9334.field_56399, (Object)class_3417.field_15239).method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)REGISTRY_ID)));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        String attack2Clip;
        AnimationController activation = new AnimationController("Activation", 0, state -> PlayState.STOP);
        RawAnimation rightHold = RawAnimation.begin().thenPlayAndHold(RAISE_RIGHT);
        RawAnimation leftHold = RawAnimation.begin().thenPlayAndHold(RAISE_LEFT);
        activation.triggerableAnim(BLOCK_TRIGGER_RIGHT, rightHold);
        activation.triggerableAnim(BLOCK_TRIGGER_LEFT, leftHold);
        activation.triggerableAnim("activate", rightHold);
        activation.setAnimationSpeedHandler(a -> Punchy.ANIM_SPEED * this.speedScale());
        activation.setCustomInstructionKeyframeHandler(event -> this.onCustomInstruction((KeyFrameEvent<AnimatedTool, CustomInstructionKeyframeData>)event));
        activation.setSoundKeyframeHandler(event -> this.onSoundKeyframe((KeyFrameEvent<AnimatedTool, SoundKeyframeData>)event));
        String attackClip = this.anim("attack");
        if (attackClip != null && !attackClip.isEmpty()) {
            activation.triggerableAnim("attack", RawAnimation.begin().thenPlay(attackClip));
        }
        if ((attack2Clip = this.anim("attack_2")) != null && !attack2Clip.isEmpty()) {
            activation.triggerableAnim("attack_2", RawAnimation.begin().thenPlay(attack2Clip));
        } else if (attackClip != null && !attackClip.isEmpty()) {
            activation.triggerableAnim("attack_2", RawAnimation.begin().thenPlay(attackClip));
        }
        String attack3Clip = this.anim("attack_3");
        if (attack3Clip != null && !attack3Clip.isEmpty()) {
            activation.triggerableAnim("attack_3", RawAnimation.begin().thenPlay(attack3Clip));
        } else if (attackClip != null && !attackClip.isEmpty()) {
            activation.triggerableAnim("attack_3", RawAnimation.begin().thenPlay(attackClip));
        }
        controllers.add(activation);
        controllers.add(new AnimationController("Inspect", 0, state -> PlayState.STOP).triggerableAnim("look_my_hand", RawAnimation.begin().thenPlay(this.anim("look_my_hand"))).setAnimationSpeedHandler(a -> 1.0).setSoundKeyframeHandler(event -> this.onSoundKeyframe((KeyFrameEvent<AnimatedTool, SoundKeyframeData>)event)));
        controllers.add(new AnimationController("Select", 0, state -> PlayState.STOP).triggerableAnim("select", RawAnimation.begin().thenPlay(this.anim("select"))).setAnimationSpeedHandler(a -> 4.5).setSoundKeyframeHandler(event -> this.onSoundKeyframe((KeyFrameEvent<AnimatedTool, SoundKeyframeData>)event)));
    }

    private static boolean isOffHand() {
        return AnimatedShield.currentActionHand() == class_1268.field_5810;
    }

    @Override
    protected String anim(String key) {
        boolean left = AnimatedShield.isOffHand();
        return switch (key) {
            case "mining", "mining_2", "mining_3", "attack", "attack_2", "attack_3" -> {
                if (left) {
                    yield RAISE_LEFT;
                }
                yield RAISE_RIGHT;
            }
            case "look_my_hand" -> {
                if (left) {
                    yield "animation.pickaxe_animated.look_my_hand_left";
                }
                yield "animation.pickaxe_animated.look_my_hand";
            }
            case "select" -> {
                if (left) {
                    yield "animation.pickaxe_animated.select_left";
                }
                yield "animation.pickaxe_animated.select";
            }
            default -> "";
        };
    }

    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private SharedShieldRenderer<AnimatedShield> renderer;

            public SharedShieldRenderer<AnimatedShield> getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SharedShieldRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (stack.method_7960()) {
            return class_1269.field_5811;
        }
        if (hand == class_1268.field_5808) {
            return class_1269.field_5811;
        }
        user.method_6019(hand);
        if (world.method_8608()) {
            class_1268 effectiveHand = hand == null ? class_1268.field_5808 : hand;
            AnimatedTool.markNextActionHand(effectiveHand);
            long id = GeoItem.getId((class_1799)stack);
            ((GeoItem)stack.method_7909()).triggerAnim((class_1297)user, id, "Activation", AnimatedShield.activationTriggerForHand(effectiveHand));
        }
        return class_1269.field_21466;
    }

    public static String activationTriggerForHand(class_1268 hand) {
        return hand == class_1268.field_5810 ? BLOCK_TRIGGER_LEFT : BLOCK_TRIGGER_RIGHT;
    }

    private static String raiseClipForHand(class_1268 hand) {
        return hand == class_1268.field_5810 ? RAISE_LEFT : RAISE_RIGHT;
    }

    private record BlockAnimationState(AnimatedShield item, long animationId, double lastLoggedSeconds) {
    }
}

