/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ExplosiveBarrelBlock
extends FallingBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ExplosiveBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState state, Level level, BlockPos blockPos, Block block, BlockPos signalPos, boolean moved) {
        if (level.m_276867_(blockPos)) {
            this.explode(level, blockPos, null);
            level.m_7471_(blockPos, false);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (FallingBlock.m_53241_((BlockState)serverLevel.m_8055_(blockPos.m_7495_())) && blockPos.m_123342_() >= serverLevel.m_141937_()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)serverLevel, (BlockPos)blockPos, (BlockState)blockState);
            fallingBlockEntity.m_272001_();
        }
    }

    public void explode(Level level, BlockPos pos, LivingEntity owner) {
        if (((Boolean)GeneralConfig.TOGGLE_DESTRUCTIVE_BLOCKS.get()).booleanValue()) {
            level.m_254849_((Entity)owner, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 4.0f, Level.ExplosionInteraction.TNT);
        } else {
            level.m_254849_((Entity)owner, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 4.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult blockHitResult, Projectile projectile) {
        if (!level.f_46443_) {
            BlockPos blockpos = blockHitResult.m_82425_();
            Entity owner = projectile.m_19749_();
            if (projectile.m_6060_() && projectile.m_142265_(level, blockpos)) {
                this.explode(level, blockpos, owner instanceof LivingEntity ? (LivingEntity)owner : null);
                level.m_7471_(blockpos, false);
                projectile.m_146870_();
            }
        }
    }

    public void m_142525_(Level level, BlockPos blockPos, FallingBlockEntity fallingBlockEntity) {
        this.explode(level, blockPos, null);
        super.m_142525_(level, blockPos, fallingBlockEntity);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
            return super.m_6227_(state, level, pos, player, hand, hitResult);
        }
        this.explode(level, pos, (LivingEntity)player);
        level.m_7471_(pos, false);
        Item item = itemstack.m_41720_();
        if (!player.m_7500_()) {
            if (itemstack.m_150930_(Items.f_42409_)) {
                itemstack.m_41622_(1, (LivingEntity)player, p_57425_ -> p_57425_.m_21190_(hand));
            } else {
                itemstack.m_41774_(1);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state1, BlockState state2, FallingBlockEntity fallingBlockEntity) {
        this.explode(level, pos, null);
        level.m_7471_(pos, false);
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource source) {
        double d0 = pos.m_123341_();
        double d1 = pos.m_123342_();
        double d2 = pos.m_123343_();
        for (int i = 0; i < 1; ++i) {
            if (!source.m_188499_()) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.5, d1 + 1.0, d2 + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType computationType) {
        return false;
    }
}

