/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai.control.look;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.phys.Vec3;

public class FairkeeperLookControl
extends LookControl {
    private final Mob mob;
    private float targetYaw;
    private boolean hasYawTarget;
    private float yawSpeed;
    private float pitchSpeed;

    public FairkeeperLookControl(Mob mob, float yawSpeed, float pitchSpeed) {
        super(mob);
        this.mob = mob;
        this.targetYaw = mob.m_146908_();
        this.hasYawTarget = false;
        this.yawSpeed = yawSpeed;
        this.pitchSpeed = pitchSpeed;
    }

    public void m_8128_() {
        Vec3 motion;
        if (this.hasYawTarget) {
            float currentYaw = this.mob.m_146908_();
            float smoothedYaw = Mth.m_14179_((float)this.yawSpeed, (float)currentYaw, (float)this.targetYaw);
            this.mob.m_146922_(smoothedYaw);
            this.mob.f_20885_ = smoothedYaw;
            this.mob.f_20883_ = smoothedYaw;
        }
        if (!(motion = this.mob.m_20184_()).equals((Object)Vec3.f_82478_)) {
            double horizontalSpeed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
            float targetPitch = (float)Math.toDegrees(Math.atan2(-motion.f_82480_, horizontalSpeed));
            float currentPitch = this.mob.m_146909_();
            float smoothedPitch = Mth.m_14179_((float)this.pitchSpeed, (float)currentPitch, (float)targetPitch);
            this.mob.m_146926_(smoothedPitch);
        }
    }

    public void setYawTarget(float targetYaw) {
        this.targetYaw = targetYaw;
        this.hasYawTarget = true;
    }

    public void m_24946_(double x, double y, double z) {
        double dx = x - this.mob.m_20185_();
        double dz = z - this.mob.m_20189_();
        float targetYaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
        this.setYawTarget(targetYaw);
    }

    public void setTransitionSpeeds(float yawSpeed, float pitchSpeed) {
        this.yawSpeed = yawSpeed;
        this.pitchSpeed = pitchSpeed;
    }
}

