/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.ai.control.move;

import dev.hexnowloading.dungeonnowloading.entity.monster.BallistaGolemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BallistaGolemMoveControl
extends MoveControl {
    private final BallistaGolemEntity ballistaGolem;
    private static final float ROTATION_RATE = 10.0f;

    public BallistaGolemMoveControl(BallistaGolemEntity ballistaGolem) {
        super((Mob)ballistaGolem);
        this.ballistaGolem = ballistaGolem;
    }

    public void m_8126_() {
        if (this.ballistaGolem.getState() == BallistaGolemEntity.BallistaGolemState.RELOAD || this.ballistaGolem.getState() == BallistaGolemEntity.BallistaGolemState.SHOOT || this.ballistaGolem.getState() == BallistaGolemEntity.BallistaGolemState.AWAKENING) {
            this.ballistaGolem.m_7910_(0.0f);
            this.ballistaGolem.m_21564_(0.0f);
            this.ballistaGolem.m_21570_(0.0f);
            return;
        }
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            int index;
            this.f_24981_ = MoveControl.Operation.WAIT;
            double deltaX = this.f_24975_ - this.ballistaGolem.m_20185_();
            double deltaY = this.f_24976_ - this.ballistaGolem.m_20186_();
            double deltaZ = this.f_24977_ - this.ballistaGolem.m_20189_();
            double distance = deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY;
            if (distance < 2.500000277905201E-7) {
                this.ballistaGolem.m_21564_(0.0f);
                return;
            }
            float desiredYaw = (float)Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0f;
            float currentYaw = this.ballistaGolem.m_146908_();
            float yawDiff = Mth.m_14177_((float)(desiredYaw - currentYaw));
            float clampedYawDiff = Mth.m_14036_((float)yawDiff, (float)-10.0f, (float)10.0f);
            this.ballistaGolem.m_146922_(currentYaw + clampedYawDiff);
            this.ballistaGolem.m_7910_((float)(this.f_24978_ * this.ballistaGolem.m_21133_(Attributes.f_22279_)));
            Path path = this.ballistaGolem.m_21573_().m_26570_();
            if (path != null && path.m_77398_() >= 2 && path.m_77399_() > 0 && (index = path.m_77399_()) < path.m_77398_() - 1) {
                boolean isMinusZtoPlusX;
                Node prev = path.m_77375_(index - 1);
                Node turn = path.m_77375_(index);
                Node next = path.m_77375_(index + 1);
                boolean isMinusXtoPlusZ = prev.f_77271_ == turn.f_77271_ - 1 && prev.f_77273_ == turn.f_77273_ && next.f_77271_ == turn.f_77271_ && next.f_77273_ == turn.f_77273_ + 1;
                boolean bl = isMinusZtoPlusX = prev.f_77271_ == turn.f_77271_ && prev.f_77273_ == turn.f_77273_ - 1 && next.f_77271_ == turn.f_77271_ + 1 && next.f_77273_ == turn.f_77273_;
                if (isMinusXtoPlusZ || isMinusZtoPlusX) {
                    double dx = (double)next.f_77271_ + 0.5 - this.ballistaGolem.m_20185_();
                    double dz = (double)next.f_77273_ + 0.5 - this.ballistaGolem.m_20189_();
                    float yawRad = this.ballistaGolem.m_146908_() * ((float)Math.PI / 180);
                    double strafeDirX = -Math.sin(yawRad);
                    double strafeDirZ = Math.cos(yawRad);
                    double dot = dx * strafeDirX + dz * strafeDirZ;
                    if (isMinusXtoPlusZ && dot > 0.0) {
                        this.ballistaGolem.m_21570_(0.2f);
                    } else if (isMinusZtoPlusX && dot > 0.0) {
                        this.ballistaGolem.m_21570_(-0.2f);
                    } else {
                        this.ballistaGolem.m_21570_(0.0f);
                    }
                }
            }
            BlockPos blockPos = this.ballistaGolem.m_20183_();
            BlockState blockState = this.ballistaGolem.m_9236_().m_8055_(blockPos);
            VoxelShape collisionShape = blockState.m_60812_((BlockGetter)this.ballistaGolem.m_9236_(), blockPos);
            if (deltaY > (double)this.ballistaGolem.m_274421_() && deltaZ * deltaZ + deltaX * deltaX < (double)Math.max(1.0f, this.ballistaGolem.m_20205_()) || !collisionShape.m_83281_() && this.ballistaGolem.m_20186_() < collisionShape.m_83297_(Direction.Axis.Y) + (double)blockPos.m_123342_() && !blockState.m_204336_(BlockTags.f_13103_) && !blockState.m_204336_(BlockTags.f_13039_)) {
                this.ballistaGolem.m_21569_().m_24901_();
                this.f_24981_ = MoveControl.Operation.JUMPING;
            }
        }
    }
}

