/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.client.model.VertexOrbProjectileModel;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public class VertexOrbProjectileRenderer<T extends VertexOrbProjectileEntity>
extends EntityRenderer<VertexOrbProjectileEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("dungeonnowloading", "textures/entity/vertex_orb_projectile.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)TEXTURE);
    private VertexOrbProjectileModel model;

    public VertexOrbProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new VertexOrbProjectileModel(context.m_174023_(VertexOrbProjectileModel.LAYER_LOCATION));
    }

    public boolean shouldRender(VertexOrbProjectileEntity entity, Frustum frustum, double x, double y, double z) {
        if (!entity.m_6000_(x, y, z)) {
            return false;
        }
        if (entity.f_19811_) {
            return true;
        }
        AABB aabb = entity.m_6921_().m_82400_(2.5);
        if (aabb.m_82392_() || aabb.m_82309_() == 0.0) {
            aabb = new AABB(entity.m_20185_() - 2.0, entity.m_20186_() - 2.0, entity.m_20189_() - 2.0, entity.m_20185_() + 2.0, entity.m_20186_() + 2.0, entity.m_20189_() + 2.0);
        }
        return frustum.m_113029_(aabb);
    }

    public void render(VertexOrbProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(RENDER_TYPE);
        boolean bl = entity.getHurtTime() > 0;
        float alpha = 1.0f;
        int fadeStart = 20;
        if (entity.getLife() > 0 && entity.getLife() < fadeStart) {
            alpha = Math.max((float)entity.getLife() / (float)fadeStart, 0.0f);
        } else if (entity.getDyingTick() > 0) {
            alpha = Math.max((float)entity.getDyingTick() / (float)fadeStart, 0.0f);
        }
        int emissiveLight = 0xF000F0;
        this.model.setupAnim(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, entityYaw, 0.0f);
        this.model.renderToBufferWithEntity(entity, poseStack, vertexConsumer, emissiveLight, OverlayTexture.m_118090_((float)0.0f, (boolean)bl), 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(VertexOrbProjectileEntity vertexOrbProjectileEntity) {
        return TEXTURE;
    }
}

