/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.passive;

import dev.hexnowloading.dungeonnowloading.config.PvpConfig;
import dev.hexnowloading.dungeonnowloading.entity.util.AnimationChainer;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.SummonFlag;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperCreepEntity
extends PathfinderMob
implements OwnableEntity,
PowerableMob {
    private static final String DEFUSED_CUSTOM_NAME = "Defused";
    private static final float EXPLOSION_RADIUS = 3.0f;
    private static final float POWERED_EXPLOSION_RADIUS = 5.0f;
    private final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.randomUUID(), "Slowdown Speed", -1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID = SynchedEntityData.m_135353_(CopperCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(CopperCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(CopperCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_ALREADY_SUMMONED = SynchedEntityData.m_135353_(CopperCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<State> STATE = SynchedEntityData.m_135353_(CopperCreepEntity.class, EntityStates.COPPER_CREEP_STATE);
    private static final EntityDataAccessor<Skin> SKIN = SynchedEntityData.m_135353_(CopperCreepEntity.class, EntityStates.COPPER_CREEP_SKIN);
    private static final EntityDataAccessor<CopperCreepAnimationState> ANIMATION_STATE = SynchedEntityData.m_135353_(CopperCreepEntity.class, EntityStates.COPPER_CREEP_ANIMATION_STATE);
    private static final EntityDataAccessor<Boolean> SKIN_VALIDATION = SynchedEntityData.m_135353_(CopperCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final byte TRIGGER_IDLE_ANIMATION_STATE = 70;
    private static final byte TRIGGER_WALKING_ANIMATION_STATE = 71;
    private static final byte TRIGGER_RUNNING_ANIMATION_STATE = 72;
    private static final byte TRIGGER_SUMMON_ANIMATION_STATE = 73;
    private static final byte TRIGGER_DETONATION_ANIMATION_STATE = 74;
    private static final byte TRIGGER_SIT_ANIMATION_STATE = 75;
    private static final byte TRIGGER_STAND_ANIMATION_STATE = 76;
    private static final byte TRIGGER_WRONG_OWNER_ANIMATION_STATE = 77;
    private static final byte TRIGGER_SITTING_ANIMATION_STATE = 78;
    private static final byte TRIGGER_SITTING_DETONATION_STATE = 79;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkingAnimationState = new AnimationState();
    public AnimationState runningAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState detonationAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState standAnimationState = new AnimationState();
    public AnimationState wrongOwnerAnimationState = new AnimationState();
    public AnimationState sittingAnimationState = new AnimationState();
    public AnimationState sittingDetonationAnimationState = new AnimationState();
    private int lightningAttractTimer = 0;
    private int swell = 0;
    private final int MAX_SWELL = Mth.m_14167_((float)25.0f);
    private Player summoner;
    private int aiTick;
    private int sitAnimationTick;
    private int standAnimationTick;
    private AnimationChainer<CopperCreepAnimationState> animationChainer = new AnimationChainer();
    public State currentState;

    @Nullable
    public UUID m_21805_() {
        return this.getSummonerUUID().orElse(null);
    }

    public CopperCreepEntity(EntityType<? extends CopperCreepEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 0;
        this.summoner = null;
        this.lightningAttractTimer = 60 * (3 + this.f_19796_.m_188503_(28));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, (double)0.175f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CopperCreepSittingGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CopperCreepFollowSummoner(this));
        this.f_21345_.m_25352_(4, (Goal)new CustomMeleeAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Monster.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> !c.m_20148_().equals(this.m_21805_()) && (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false && c instanceof OwnableEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, c -> !c.m_20148_().equals(this.m_21805_()) && (Boolean)PvpConfig.TOGGLE_PVP_MODE.get() != false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> c instanceof Enemy));
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public float getSwelling(float f) {
        if (this.MAX_SWELL == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)this.swell / (float)this.MAX_SWELL), (float)0.0f, (float)1.0f);
    }

    public Optional<UUID> getSummonerUUID() {
        return (Optional)this.f_19804_.m_135370_(SUMMONER_UUID);
    }

    public void setSummonerUUID(UUID summonerUUID) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.of(summonerUUID));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)CopperCreepAnimationState.IDLE);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_ALREADY_SUMMONED, (Object)false);
        this.f_19804_.m_135372_(STATE, (Object)State.SUMMONING);
        this.f_19804_.m_135372_(SKIN, (Object)Skin.DEFAULT);
        this.f_19804_.m_135372_(SKIN_VALIDATION, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.getSummonerUUID().ifPresent(uuid -> compoundTag.m_128362_("summonerUUID", uuid));
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            compoundTag.m_128379_("powered", true);
        }
        compoundTag.m_128379_("ignited", this.isIgnited());
        compoundTag.m_128379_("isAlreadySummoned", this.isAlreadySummoned());
        compoundTag.m_128379_("isSitting", this.isState(State.SITTING));
        compoundTag.m_128379_("isWandering", this.isState(State.WANDERING));
        compoundTag.m_128359_("skin", this.getSkin().getId());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("summonerUUID")) {
            UUID summonerUUID = compoundTag.m_128342_("summonerUUID");
            this.setSummonerUUID(summonerUUID);
        }
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)compoundTag.m_128471_("powered"));
        if (compoundTag.m_128471_("ignited") && !this.isDefused()) {
            this.ignite();
        }
        this.f_19804_.m_135381_(DATA_IS_ALREADY_SUMMONED, (Object)compoundTag.m_128471_("isAlreadySummoned"));
        if (compoundTag.m_128471_("isSitting")) {
            this.setState(State.SITTING);
        }
        if (compoundTag.m_128471_("isWandering")) {
            this.setState(State.WANDERING);
        }
        if (SummonFlag.isSummoning()) {
            this.setSkinValidation(true);
        }
        if (compoundTag.m_128441_("skin") && !((Boolean)this.f_19804_.m_135370_(SKIN_VALIDATION)).booleanValue()) {
            this.f_19804_.m_135381_(SKIN, (Object)Skin.fromId(compoundTag.m_128461_("skin")));
        }
        this.setSkinValidation(true);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_204117_(ItemTags.f_262757_)) {
            SoundEvent soundEvent = itemStack.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.isDefused()) {
                this.ignite();
            }
            if (!this.m_9236_().f_46443_) {
                if (!itemStack.m_41763_()) {
                    itemStack.m_41774_(1);
                } else {
                    itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(interactionHand));
                }
            }
        } else if (!this.m_9236_().f_46443_) {
            Optional<UUID> summonerUUID = this.getSummonerUUID();
            if (summonerUUID.isPresent() && summonerUUID.get().equals(player.m_20148_())) {
                if (this.getState() == State.IDLE || this.getState() == State.FOLLOWING) {
                    if (this.isDefused() && this.canSit() && this.sitAnimationTick <= 0) {
                        player.m_5661_((Component)Component.m_237115_((String)"entity.dungeonnowloading.copper_creep.state_wander"), true);
                        this.setState(State.WANDERING);
                    } else {
                        this.rightClickToSit(player);
                    }
                } else if (this.getState() == State.WANDERING && this.canSit() && this.sitAnimationTick <= 0) {
                    this.rightClickToSit(player);
                } else if (this.getState() == State.SITTING && this.sitAnimationTick <= 0) {
                    player.m_5661_((Component)Component.m_237115_((String)"entity.dungeonnowloading.copper_creep.state_follow"), true);
                    this.standUp();
                }
            } else {
                this.playWrongOwnerAnimation();
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    private void rightClickToSit(Player player) {
        player.m_5661_((Component)Component.m_237115_((String)"entity.dungeonnowloading.copper_creep.state_sit"), true);
        this.triggerSitAnimation();
        this.setState(State.SIT);
        this.m_216990_(DNLSounds.COPPER_CREEP_SIT_DOWN.get());
        this.m_21573_().m_26573_();
        AttributeInstance moveSpeedAttr = this.m_21051_(Attributes.f_22279_);
        if (moveSpeedAttr != null && !moveSpeedAttr.m_22109_(this.SPEED_MODIFIER)) {
            moveSpeedAttr.m_22118_(this.SPEED_MODIFIER);
        }
        this.sitAnimationTick = Mth.m_14167_((float)15.0f);
    }

    private boolean canSit() {
        return !this.m_20072_() && this.m_20096_();
    }

    public Player getSummoner() {
        if (this.summoner == null) {
            Optional<UUID> summonerUUID = this.getSummonerUUID();
            summonerUUID.ifPresent(value -> {
                this.summoner = this.m_9236_().m_46003_(value);
            });
        }
        return this.summoner;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void m_8024_() {
        if (this.aiTick == 0 && !this.isAlreadySummoned()) {
            this.setState(State.SUMMONING);
            this.triggerSummonAnimation();
            this.m_216990_(DNLSounds.COPPER_CREEP_SPAWN.get());
            this.f_19804_.m_135381_(DATA_IS_ALREADY_SUMMONED, (Object)true);
        }
        if (this.isState(State.SUMMONING) && this.aiTick == 20) {
            this.setState(State.IDLE);
        }
        if (this.getState() != State.SIT && this.getState() != State.SITTING && this.getState() != State.STAND && this.getState() != State.WANDERING) {
            if (this.m_5448_() == null) {
                this.setState(State.IDLE);
            } else {
                this.setState(State.FOLLOWING);
            }
        }
        if (this.sitAnimationTick-- > 0 && this.sitAnimationTick <= 0) {
            this.m_21573_().m_26573_();
            this.setState(State.SITTING);
        }
        if (this.standAnimationTick-- > 0 && this.standAnimationTick <= 0) {
            this.m_21573_().m_26573_();
            this.setState(State.IDLE);
        }
        ++this.aiTick;
        super.m_8024_();
    }

    public boolean isAlreadySummoned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_ALREADY_SUMMONED);
    }

    public void m_8119_() {
        if (this.lightningAttractTimer > 0) {
            --this.lightningAttractTimer;
        }
        if (this.lightningAttractTimer == 0 && !this.m_7090_()) {
            this.attemptToAttractLightning();
        }
        if (this.isIgnited()) {
            if (this.swell == 0) {
                if (this.getState() == State.SITTING) {
                    this.triggerSittingDetonationAnimation();
                    this.setState(State.SITTING_DETONATION);
                } else {
                    AttributeInstance moveSpeedAttr = this.m_21051_(Attributes.f_22279_);
                    if (moveSpeedAttr != null && !moveSpeedAttr.m_22109_(this.SPEED_MODIFIER)) {
                        moveSpeedAttr.m_22118_(this.SPEED_MODIFIER);
                    }
                    this.triggerDetonationAnimation();
                    this.setState(State.DETONATION);
                }
                this.m_216990_(DNLSounds.COPPER_CREEP_PRIME.get());
            }
            if (this.swell < this.MAX_SWELL) {
                ++this.swell;
            } else if (!this.m_9236_().f_46443_) {
                this.f_20890_ = true;
                float finalExplosionRadius = 3.0f;
                if (this.m_7090_()) {
                    finalExplosionRadius = 5.0f;
                }
                DamageSource source = this.m_9236_().m_269111_().m_269036_((Entity)this, (Entity)this.getSummoner());
                this.m_9236_().m_254877_((Entity)this, source, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), finalExplosionRadius, false, Level.ExplosionInteraction.NONE);
                this.m_146870_();
                this.spawnLingeringCloud();
            }
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.animationChainer.tick(this::transitionTo);
        }
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (this.getState() == State.IDLE || this.getState() == State.WANDERING) {
            this.standAnimationState.m_216973_();
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.getState() == State.SITTING) {
            this.sitAnimationState.m_216973_();
            this.sittingAnimationState.m_216982_(this.f_19797_);
        }
    }

    private void spawnLingeringCloud() {
        Collection mobEffectInstances = this.m_21220_();
        if (!mobEffectInstances.isEmpty()) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaEffectCloud.m_19712_(2.5f);
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19734_(areaEffectCloud.m_19748_() / 2);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            for (MobEffectInstance effectInstance : mobEffectInstances) {
                areaEffectCloud.m_19716_(new MobEffectInstance(effectInstance));
            }
            this.m_9236_().m_7967_((Entity)areaEffectCloud);
        }
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        this.m_7311_(this.m_20094_() + 1);
        if (this.m_20094_() == 0) {
            this.m_20254_(8);
        }
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    private boolean isPlayerOnDifferentTeam(Player player) {
        Optional<UUID> summonerUUID = this.getSummonerUUID();
        UUID playerUUID = player.m_20148_();
        if (summonerUUID.isPresent() && summonerUUID.get().equals(playerUUID)) {
            return false;
        }
        if (player.m_7500_() || player.m_5833_()) {
            return false;
        }
        if (!summonerUUID.isPresent()) {
            return false;
        }
        Player summoner = this.getSummoner();
        if (summoner == null) {
            return false;
        }
        boolean isAllied = player.m_7307_((Entity)summoner);
        return !isAllied;
    }

    public boolean isDefused() {
        return this.m_8077_();
    }

    private void attemptToAttractLightning() {
        LightningBolt lightningBolt;
        if (this.m_9236_().m_46470_() && this.hasClearSkyAbove() && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
            lightningBolt.m_6027_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_9236_().m_7967_((Entity)lightningBolt);
            this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
        }
    }

    private boolean hasClearSkyAbove() {
        BlockPos posAbove = this.m_20183_().m_7494_();
        while (posAbove.m_123342_() < this.m_9236_().m_151558_()) {
            if (!this.m_9236_().m_46859_(posAbove)) {
                return false;
            }
            posAbove = posAbove.m_7494_();
        }
        return true;
    }

    private void standUp() {
        this.triggerStandAnimation();
        this.setState(State.STAND);
        this.m_216990_(DNLSounds.COPPER_CREEP_STAND_UP.get());
        this.m_21573_().m_26573_();
        AttributeInstance moveSpeedAttr = this.m_21051_(Attributes.f_22279_);
        if (moveSpeedAttr != null) {
            moveSpeedAttr.m_22130_(this.SPEED_MODIFIER);
        }
        this.standAnimationTick = Mth.m_14167_((float)13.334f);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean hurt = super.m_6469_(damageSource, amount);
        if (hurt && !this.m_9236_().f_46443_ && this.getState() == State.SITTING) {
            this.standUp();
        }
        return hurt;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.4f;
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
        if (this.getState() == State.SITTING || this.getState() == State.SITTING_DETONATION) {
            return;
        }
        this.m_5496_(DNLSounds.COPPER_CREEP_STEP.get(), 0.5f, 1.0f);
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(DNLSounds.COPPER_CREEP_LAND.get(), DNLSounds.COPPER_CREEP_LAND.get());
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return DNLSounds.COPPER_CREEP_HIT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return DNLSounds.COPPER_CREEP_DEATH.get();
    }

    public State getState() {
        return (State)((Object)this.f_19804_.m_135370_(STATE));
    }

    public boolean isState(State state) {
        return this.getState().equals((Object)state);
    }

    private void playWrongOwnerAnimation() {
        this.animationChainer.reset();
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.of(CopperCreepAnimationState.WRONG_OWNER, 0.3333f));
        this.animationChainer.enqueue(AnimationChainer.AnimationStep.looping(CopperCreepAnimationState.IDLE, 2.0f));
    }

    private void triggerSummonAnimation() {
        this.transitionTo(CopperCreepAnimationState.SUMMON);
    }

    private void triggerDetonationAnimation() {
        this.transitionTo(CopperCreepAnimationState.DETONATION);
    }

    private void triggerSitAnimation() {
        this.transitionTo(CopperCreepAnimationState.SIT);
    }

    private void triggerStandAnimation() {
        this.transitionTo(CopperCreepAnimationState.STAND);
    }

    private void triggerWrongOwnerAnimation() {
        this.transitionTo(CopperCreepAnimationState.WRONG_OWNER);
    }

    private void triggerSittingDetonationAnimation() {
        this.transitionTo(CopperCreepAnimationState.SITTING_DETONATION);
    }

    private void setState(State state) {
        this.currentState = state;
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public Skin getSkin() {
        return (Skin)((Object)this.f_19804_.m_135370_(SKIN));
    }

    public void setSkin(Skin skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public void setCosmeticMode(String id) {
        this.setSkin(Skin.fromId(id));
    }

    public void setSkinValidation(boolean skinValidation) {
        this.f_19804_.m_135381_(SKIN_VALIDATION, (Object)skinValidation);
    }

    public CopperCreepAnimationState getAnimationState() {
        return (CopperCreepAnimationState)((Object)this.f_19804_.m_135370_(ANIMATION_STATE));
    }

    public void setAnimationState(CopperCreepAnimationState animationState) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)animationState);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIMATION_STATE.equals(entityDataAccessor)) {
            CopperCreepAnimationState animationState = this.getAnimationState();
            this.resetAnimations();
            switch (animationState) {
                case IDLE: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SUMMON: {
                    this.summonAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case DETONATION: {
                    this.detonationAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SIT: {
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case STAND: {
                    this.standAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case WRONG_OWNER: {
                    this.wrongOwnerAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SITTING: {
                    this.sittingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SITTING_DETONATION: {
                    this.sittingDetonationAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public CopperCreepEntity transitionTo(CopperCreepAnimationState animationState) {
        switch (animationState) {
            case IDLE: {
                this.setAnimationState(CopperCreepAnimationState.IDLE);
                break;
            }
            case SUMMON: {
                this.setAnimationState(CopperCreepAnimationState.SUMMON);
                break;
            }
            case DETONATION: {
                this.setAnimationState(CopperCreepAnimationState.DETONATION);
                break;
            }
            case SIT: {
                this.setAnimationState(CopperCreepAnimationState.SIT);
                break;
            }
            case STAND: {
                this.setAnimationState(CopperCreepAnimationState.STAND);
                break;
            }
            case WRONG_OWNER: {
                this.setAnimationState(CopperCreepAnimationState.WRONG_OWNER);
                break;
            }
            case SITTING: {
                this.setAnimationState(CopperCreepAnimationState.SITTING);
                break;
            }
            case SITTING_DETONATION: {
                this.setAnimationState(CopperCreepAnimationState.SITTING_DETONATION);
            }
        }
        return this;
    }

    private void resetAnimations() {
        this.idleAnimationState.m_216973_();
        this.walkingAnimationState.m_216973_();
        this.runningAnimationState.m_216973_();
        this.summonAnimationState.m_216973_();
        this.detonationAnimationState.m_216973_();
        this.sitAnimationState.m_216973_();
        this.sittingAnimationState.m_216973_();
        this.standAnimationState.m_216973_();
        this.wrongOwnerAnimationState.m_216973_();
        this.sittingDetonationAnimationState.m_216973_();
    }

    private class CopperCreepSittingGoal
    extends Goal {
        private final CopperCreepEntity copperCreep;

        public CopperCreepSittingGoal(CopperCreepEntity copperCreep) {
            this.copperCreep = copperCreep;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            return this.copperCreep.getState() == State.SITTING;
        }

        public void m_8056_() {
            this.copperCreep.m_21573_().m_26573_();
            this.copperCreep.m_6710_(null);
        }
    }

    private class CopperCreepFollowSummoner
    extends Goal {
        private final CopperCreepEntity copperCreep;
        private int updatePathTick;
        private float speed;

        public CopperCreepFollowSummoner(CopperCreepEntity copperCreep) {
            this.copperCreep = copperCreep;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.copperCreep.getState() == State.IDLE && this.copperCreep.m_5448_() == null && this.copperCreep.getSummoner() != null;
        }

        public boolean m_8045_() {
            return this.copperCreep.getState() != State.WANDERING && this.copperCreep.m_5448_() == null && this.copperCreep.getSummoner() != null;
        }

        public void m_8041_() {
            this.copperCreep.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.updatePathTick-- > 0) {
                Player summoner = this.copperCreep.getSummoner();
                float distance = this.copperCreep.m_20270_((Entity)summoner);
                if (distance < 5.0f) {
                    this.speed = 0.8f;
                    this.copperCreep.setState(State.WALKING_TOWARDS_PLAYER);
                } else {
                    this.speed = 2.0f;
                    this.copperCreep.setState(State.RUNNING_TOWARDS_PLAYER);
                }
            } else {
                this.copperCreep.m_21573_().m_5624_((Entity)this.copperCreep.getSummoner(), (double)this.speed);
                this.updatePathTick = this.m_183277_(10);
            }
        }
    }

    private class CustomMeleeAttackGoal
    extends MeleeAttackGoal {
        private final CopperCreepEntity copperCreep;

        public CustomMeleeAttackGoal(CopperCreepEntity mob, double v, boolean b) {
            super((PathfinderMob)mob, v, b);
            this.copperCreep = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.copperCreep.getState() != State.WANDERING && super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.copperCreep.getState() != State.FOLLOWING) {
                return false;
            }
            return super.m_8045_();
        }

        protected void m_6739_(LivingEntity $$0, double $$1) {
        }
    }

    public static enum CopperCreepAnimationState {
        IDLE,
        SUMMON,
        DETONATION,
        SIT,
        STAND,
        WRONG_OWNER,
        SITTING,
        SITTING_DETONATION;

    }

    public static enum State {
        SUMMONING,
        IDLE,
        RUNNING_TOWARDS_PLAYER,
        WALKING_TOWARDS_PLAYER,
        FOLLOWING,
        WANDERING,
        DETONATION,
        SITTING_DETONATION,
        SITTING,
        SIT,
        STAND,
        WRONG_OWNER;

    }

    public static enum Skin {
        DEFAULT("default"),
        BUTLER("butler");

        public final String name;

        private Skin(String name) {
            this.name = name;
        }

        public String getId() {
            return this.name;
        }

        public static Skin fromId(String id) {
            for (Skin skin : Skin.values()) {
                if (!skin.name.equalsIgnoreCase(id)) continue;
                return skin;
            }
            return DEFAULT;
        }
    }

    private class CopperCreepInWaterGoal
    extends Goal {
        private final CopperCreepEntity copperCreep;

        public CopperCreepInWaterGoal(CopperCreepEntity copperCreep) {
            this.copperCreep = copperCreep;
        }

        public boolean m_8036_() {
            return this.copperCreep.getState() == State.SITTING && !this.copperCreep.canSit();
        }

        public void m_8056_() {
            this.copperCreep.standUp();
        }
    }
}

