/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.components.VertexNode;
import dev.hexnowloading.dungeonnowloading.potion.VertexTransmissionEffect;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLMobEffects;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.DNLMath;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class VertexArrowProjectileEntity
extends AbstractArrow {
    private int powerLevel = 0;
    private VertexNode vertexNode = new VertexNode((Entity)this);
    private int powerIncrementTimer = 0;
    private int life;
    private static final EntityDataAccessor<Integer> POWER_LEVEL = SynchedEntityData.m_135353_(VertexArrowProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int ENTITY_DIRECT_HIT_EFFECT_DURATION_TICKS = 120;
    private static final int ADVANCE_POWER_LEVEL_THRESHOLD_TICKS = 8;
    private static final int MAX_POWER_LEVEL = 3;
    private static final int DESPAWN_TIME_TICKS = 400;

    public VertexArrowProjectileEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public VertexArrowProjectileEntity(Level level, LivingEntity shooter) {
        super(DNLEntityTypes.VERTEX_ARROW_PROJECTILE.get(), shooter, level);
    }

    public int getPowerLevel() {
        return (Integer)this.f_19804_.m_135370_(POWER_LEVEL);
    }

    public boolean isFullyPowered() {
        return this.powerLevel == 3;
    }

    public VertexNode getVertexNode() {
        return this.vertexNode;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POWER_LEVEL, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("powerLevel", ((Integer)this.f_19804_.m_135370_(POWER_LEVEL)).intValue());
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(POWER_LEVEL, (Object)compoundTag.m_128451_("powerLevel"));
    }

    protected void m_6901_() {
        ++this.life;
        if (this.life >= 400) {
            this.vertexNode.disconnect_all();
            this.m_146870_();
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            int slownessDurationTicks = 120;
            int slownessAmplifier = this.vertexNode.getConnectionCount();
            int vertexTransDurationTicks = 120;
            int vertexTransAmplifier = 0;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessDurationTicks, slownessAmplifier));
            boolean entityHasEffect = entity2.m_21023_(DNLMobEffects.VERTEX_TRANSMISSION.get());
            if (!entityHasEffect) {
                entity2.m_7292_(new MobEffectInstance(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
            } else {
                entity2.m_7292_(new MobEffectInstance(DNLMobEffects.VERTEX_TRANSMISSION.get(), vertexTransDurationTicks, vertexTransAmplifier));
                VertexTransmissionEffect vertexTransmissionEffect = (VertexTransmissionEffect)entity2.m_21124_(DNLMobEffects.VERTEX_TRANSMISSION.get()).m_19544_();
                vertexTransmissionEffect.markAsReconnectionCase(entity2.m_20148_());
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_36703_) {
            this.vertexNode.disconnect_all();
            this.powerIncrementTimer = 0;
            this.powerLevel = 0;
            this.f_19804_.m_135381_(POWER_LEVEL, (Object)0);
        } else {
            if (this.powerLevel == 0 && this.powerIncrementTimer == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), DNLSounds.VERTEX_ARROW_BOOTUP.get(), SoundSource.PLAYERS, 1.0f, 1.2f / (DNLMath.randomRange(0.0f, 1.0f) * 0.2f + 0.9f));
            }
            if (this.powerLevel < 3) {
                ++this.powerIncrementTimer;
                if (this.powerIncrementTimer >= 8) {
                    ++this.powerLevel;
                    this.f_19804_.m_135381_(POWER_LEVEL, (Object)this.powerLevel);
                    this.powerIncrementTimer = 0;
                }
            } else if (!this.m_9236_().f_46443_ && !this.vertexNode.attemptedConnection() && this.life != 400) {
                this.vertexNode.connectToNearbyNodes((Entity)this);
            }
        }
        this.vertexNode.tick((Entity)this);
    }
}

