/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.entity.projectile.FlameProjectileEntity;
import dev.hexnowloading.dungeonnowloading.item.DNLAnimatedItem;
import dev.hexnowloading.dungeonnowloading.item.DNLAnimationState;
import dev.hexnowloading.dungeonnowloading.item.client.ItemAnimationState;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ScorcherItem
extends Item
implements DNLAnimatedItem<ScorcherAnimationState> {
    private static final String HEAT_TAG = "ScorcherHeat";
    private static final String HEAT_TIME_STAMP = "ScorcherTimeStamp";
    private static final String BURN_TIME = "BurnTime";
    private static final Map<Item, FuelProperties> FUEL_TYPE = new HashMap<Item, FuelProperties>();

    public ScorcherItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), level.m_46467_())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!this.hasFuel(player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), level.m_46467_())) {
            if (!level.f_46443_) {
                ItemAnimationState.start(stack, ScorcherAnimationState.SCORCHER_STALLING.getName(), level.m_46467_(), 20L, false, false);
                this.playScorcherSounds(stack, player, DNLSounds.SCORCHER_STALL.get(), DNLSounds.SOUL_SCORCHER_STALL.get());
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        if (!level.f_46443_) {
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private boolean hasFuel(Player player) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        ItemStack offHandItem = player.m_21206_();
        if (FUEL_TYPE.containsKey(offHandItem.m_41720_())) {
            return true;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = player.m_150109_().m_8020_(i);
            if (!FUEL_TYPE.containsKey(itemStack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public UseAnim m_6164_(ItemStack $$0) {
        return super.m_6164_($$0);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack itemStack, int remainingUseDuration) {
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int chargeTime = this.m_8105_(itemStack) - remainingUseDuration;
        long gameTime = player.m_9236_().m_46467_();
        float overHeatedDuration = 1.3333334f;
        int activeAnimDuration = 25;
        int shootAnimDuration = (int)(120.0f + (float)activeAnimDuration);
        if (ItemAnimationState.isAnimating(itemStack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), level.m_46467_())) {
            return;
        }
        if (chargeTime == 0) {
            ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_ACTIVATED.getName(), gameTime, 25L, false, true);
            this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_START.get(), DNLSounds.SOUL_SCORCHER_START.get());
        }
        if (chargeTime == activeAnimDuration) {
            ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime, 120L, false, true);
            this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_SHOOT.get(), DNLSounds.SOUL_SCORCHER_SHOOT.get());
        }
        if (chargeTime == shootAnimDuration) {
            ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime, 160L, false, true);
            this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_OVERHEAT.get(), DNLSounds.SOUL_SCORCHER_OVERHEAT.get());
            ScorcherItem.setHeatLevel(itemStack, overHeatedDuration, gameTime);
            player.m_21253_();
            return;
        }
        float maxHeatDuration = 120.0f;
        float heatIncreasePerTick = 1.0f / maxHeatDuration;
        if (ItemAnimationState.isAnimating(itemStack, ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime)) {
            if (this.getBurnTime(itemStack) <= 0) {
                ItemStack fuelItemStack = this.getFuel(player);
                if (fuelItemStack.m_41619_()) {
                    player.m_21253_();
                    return;
                }
                this.setFuelNBT(itemStack, fuelItemStack.m_41720_());
                FuelProperties properties = FUEL_TYPE.get(fuelItemStack.m_41720_());
                if (properties == null) {
                    player.m_21253_();
                    return;
                }
                this.setBurnTime(itemStack, properties.getBurnTime());
                if (this.getBurnTime(itemStack) <= 0) {
                    player.m_21253_();
                    return;
                }
                this.depleteFuel(fuelItemStack, player);
            }
            if (this.getBurnTime(itemStack) > 0) {
                this.setBurnTime(itemStack, this.getBurnTime(itemStack) - 1);
            }
            if (this.getBurnTime(itemStack) % 20 == 0) {
                itemStack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            this.shootFlame(level, (LivingEntity)player, itemStack, ScorcherItem.getFuelType(itemStack));
            float heat = ScorcherItem.getHeatLevel(itemStack);
            heat = Math.min(1.0f, heat + heatIncreasePerTick);
            ScorcherItem.setHeatLevel(itemStack, heat, gameTime);
            if (heat >= 1.0f) {
                ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime, 160L, false, true);
                this.playScorcherSounds(itemStack, player, DNLSounds.SCORCHER_OVERHEAT.get(), DNLSounds.SOUL_SCORCHER_OVERHEAT.get());
                this.stopScorcherSounds(itemStack, player, DNLSounds.SCORCHER_SHOOT.get(), DNLSounds.SOUL_SCORCHER_SHOOT.get());
                ScorcherItem.setHeatLevel(itemStack, overHeatedDuration, gameTime);
                player.m_21253_();
                return;
            }
        }
    }

    private ItemStack getFuel(Player player) {
        ItemStack offHandItem = player.m_21206_();
        if (FUEL_TYPE.containsKey(offHandItem.m_41720_())) {
            return offHandItem;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack = player.m_150109_().m_8020_(i);
            if (!FUEL_TYPE.containsKey(itemStack.m_41720_())) continue;
            return itemStack;
        }
        if (player.m_150110_().f_35937_) {
            return new ItemStack((ItemLike)Items.f_42413_);
        }
        return ItemStack.f_41583_;
    }

    private void depleteFuel(ItemStack fuelStack, Player player) {
        if (!player.m_150110_().f_35937_) {
            if (fuelStack.m_41613_() > 1) {
                fuelStack.m_41774_(1);
            } else {
                fuelStack.m_41764_(0);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        long gameTime = level.m_46467_();
        if (!level.f_46443_ && stack.m_41720_() instanceof ScorcherItem && entity instanceof Player) {
            Player player = (Player)entity;
            long storedGameTime = ScorcherItem.getTimeStamp(stack);
            if (storedGameTime != gameTime) {
                float heat = ScorcherItem.getHeatLevel(stack);
                long timeElapsed = gameTime - storedGameTime;
                float heatDecayPerTick = 0.008333334f;
                heat = Math.max(0.0f, heat - (float)timeElapsed * heatDecayPerTick);
                ScorcherItem.setHeatLevel(stack, heat, gameTime);
            }
            if (!(isSelected || player.m_21205_().m_150930_(stack.m_41720_()) && (player.m_6117_() || ItemAnimationState.isAnimating(player.m_21205_(), ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime)))) {
                this.stopScorcherLingeringSounds(stack, player);
            }
            if (!isSelected && !ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), gameTime)) {
                if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_SHOOT.getName(), gameTime)) {
                    ItemAnimationState.start(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime, 25L, false, true);
                } else if (!ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime)) {
                    ItemAnimationState.stopAll(stack);
                }
            }
        }
    }

    @Override
    public void playDroppedAnimation(Player player, ItemStack itemStack) {
        long gameTime = player.m_9236_().m_46467_();
        this.stopScorcherLingeringSounds(itemStack, player);
        ItemAnimationState.start(itemStack, ScorcherAnimationState.SCORCHER_STOP.getName(), gameTime, 25L, false, true);
    }

    private void shootFlame(Level level, LivingEntity player, ItemStack itemStack, Item fuelItem) {
        Vec3 eyePosition = player.m_146892_();
        Vec3 viewVector = player.m_20252_(1.0f);
        Vec3 rightVector = new Vec3(-viewVector.f_82481_, 0.0, viewVector.f_82479_).m_82541_();
        FuelProperties properties = FUEL_TYPE.get(fuelItem);
        if (properties == null) {
            return;
        }
        double rightOffset = 0.175;
        double verticalOffset = -0.25;
        Vec3 spawnPosition = eyePosition.m_82549_(viewVector.m_82490_(0.6)).m_82549_(rightVector.m_82490_(rightOffset)).m_82520_(0.0, verticalOffset, 0.0);
        Vec3 targetPosition = eyePosition.m_82549_(viewVector.m_82490_(30.0)).m_82520_(0.0, -verticalOffset, 0.0);
        Vec3 correctedDirection = targetPosition.m_82546_(spawnPosition).m_82541_();
        double spread = properties.getSpread();
        RandomSource random = level.m_213780_();
        double spreadX = (random.m_188500_() - 0.5) * spread;
        double spreadY = (random.m_188500_() - 0.5) * spread;
        double spreadZ = (random.m_188500_() - 0.5) * spread;
        Vec3 spreadVector = new Vec3(spreadX, spreadY, spreadZ);
        correctedDirection = correctedDirection.m_82549_(spreadVector).m_82541_();
        FlameProjectileEntity flame = new FlameProjectileEntity(player, level);
        flame.m_5602_((Entity)player);
        flame.m_6034_(spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_);
        if (itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get())) {
            flame.setDamage(5.0f + properties.getBonusDamage());
            flame.setSoul(true);
        } else {
            flame.setDamage(4.0f + properties.getBonusDamage());
        }
        flame.m_20256_(correctedDirection.m_82490_(properties.getBulletSpeed()));
        level.m_7967_((Entity)flame);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeCharged) {
        if (level.f_46443_) {
            return;
        }
        if (ItemAnimationState.isAnimating(stack, ScorcherAnimationState.SCORCHER_OVERHEAT.getName(), level.m_46467_())) {
            return;
        }
        ItemAnimationState.start(stack, ScorcherAnimationState.SCORCHER_STOP.getName(), level.m_46467_(), 25L, false, true);
        this.playScorcherSounds(stack, (Player)entity, DNLSounds.SCORCHER_STOP.get(), DNLSounds.SOUL_SCORCHER_STOP.get());
        this.stopScorcherSounds(stack, (Player)entity, DNLSounds.SCORCHER_SHOOT.get(), DNLSounds.SOUL_SCORCHER_SHOOT.get());
    }

    private void playScorcherSounds(ItemStack itemStack, Player player, SoundEvent scorcher, SoundEvent soulScorcher) {
        float radius = 32.0f;
        AABB detectionBox = player.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = player.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ResourceLocation sound = itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get()) ? soulScorcher.m_11660_() : scorcher.m_11660_();
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(player.m_19879_(), sound, SoundSource.PLAYERS), otherPlayer);
        }
    }

    private void stopScorcherLingeringSounds(ItemStack itemStack, Player player) {
        float radius = 32.0f;
        AABB detectionBox = player.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = player.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ArrayList<ResourceLocation> soundsToStop = new ArrayList<ResourceLocation>(List.of());
        if (itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get())) {
            soundsToStop.add(DNLSounds.SOUL_SCORCHER_START.get().m_11660_());
            soundsToStop.add(DNLSounds.SOUL_SCORCHER_SHOOT.get().m_11660_());
            soundsToStop.add(DNLSounds.SOUL_SCORCHER_OVERHEAT.get().m_11660_());
        } else {
            soundsToStop.add(DNLSounds.SCORCHER_START.get().m_11660_());
            soundsToStop.add(DNLSounds.SCORCHER_SHOOT.get().m_11660_());
            soundsToStop.add(DNLSounds.SCORCHER_OVERHEAT.get().m_11660_());
        }
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            for (ResourceLocation sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(player.m_19879_(), sound, 20, true), otherPlayer);
            }
        }
    }

    private void stopScorcherSounds(ItemStack itemStack, Player player, SoundEvent scorcher, SoundEvent soulScorcher) {
        float radius = 32.0f;
        AABB detectionBox = player.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = player.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ResourceLocation sound = itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get()) ? soulScorcher.m_11660_() : scorcher.m_11660_();
        for (ServerPlayer otherPlayer : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(player.m_19879_(), sound, 20, true), otherPlayer);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            if (itemStack.m_150930_(DNLItems.SCORCHER.get())) {
                components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.scorcher.tooltip.ability_name").m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.scorcher.tooltip.ability_description").m_130940_(ChatFormatting.DARK_GRAY));
            } else if (itemStack.m_150930_(DNLItems.SOUL_SCORCHER.get())) {
                components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.soul_scorcher.tooltip.ability_name").m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.soul_scorcher.tooltip.ability_description").m_130940_(ChatFormatting.DARK_GRAY));
            }
            components.add(CommonComponents.f_237098_);
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.scorcher_common.tooltip.cost").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.scorcher_common.tooltip.cost.coal").m_130940_(ChatFormatting.DARK_GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.scorcher_common.tooltip.cost.charcoal").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public static void setHeatLevel(ItemStack stack, float heatLevel, long timeStamp) {
        stack.m_41784_().m_128350_(HEAT_TAG, heatLevel);
        stack.m_41784_().m_128356_(HEAT_TIME_STAMP, timeStamp);
    }

    private static void ensureUUID(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (!stack.m_41783_().m_128441_("ScorcherUUID")) {
            stack.m_41783_().m_128362_("ScorcherUUID", UUID.randomUUID());
        }
    }

    private void setFuelNBT(ItemStack weaponItemStack, Item fuelItem) {
        CompoundTag tag = weaponItemStack.m_41784_();
        ResourceLocation fuelId = BuiltInRegistries.f_257033_.m_7981_((Object)fuelItem);
        if (fuelId != null) {
            tag.m_128359_("FuelType", fuelId.toString());
        }
    }

    public static Item getFuelType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("FuelType")) {
            ResourceLocation fuelId = new ResourceLocation(tag.m_128461_("FuelType"));
            return (Item)BuiltInRegistries.f_257033_.m_7745_(fuelId);
        }
        return Items.f_41852_;
    }

    private void setBurnTime(ItemStack itemStack, int tick) {
        itemStack.m_41784_().m_128405_(BURN_TIME, tick);
    }

    private int getBurnTime(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_(BURN_TIME)) {
            return tag.m_128451_(BURN_TIME);
        }
        return 0;
    }

    public static float getHeatLevel(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128457_(HEAT_TAG) : 0.0f;
    }

    public static long getTimeStamp(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128454_(HEAT_TIME_STAMP) : 0L;
    }

    @Override
    public Class<ScorcherAnimationState> getAnimationEnum() {
        return ScorcherAnimationState.class;
    }

    static {
        FUEL_TYPE.put(Items.f_42413_, new FuelProperties(0.5, 0.0f, 0.4, 30));
        FUEL_TYPE.put(Items.f_42414_, new FuelProperties(0.5, 0.0f, 0.4, 20));
    }

    public static enum ScorcherAnimationState implements DNLAnimationState
    {
        SCORCHER_ACTIVATED("scorcher_activated"),
        SCORCHER_SHOOT("scorcher_shoot"),
        SCORCHER_STOP("scorcher_stop"),
        SCORCHER_STALLING("scorcher_stalling"),
        SCORCHER_OVERHEAT("scorcher_overheat"),
        SCORCHER_BASE("scorcher_base");

        private final String name;

        private ScorcherAnimationState(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class FuelProperties {
        private final double spread;
        private final float bonusDamage;
        private final double bulletSpeed;
        private final int burnTime;

        public FuelProperties(double spread, float bonusDamage, double bulletSpeed, int burnTime) {
            this.spread = spread;
            this.bonusDamage = bonusDamage;
            this.bulletSpeed = bulletSpeed;
            this.burnTime = burnTime;
        }

        public double getSpread() {
            return this.spread;
        }

        public float getBonusDamage() {
            return this.bonusDamage;
        }

        public double getBulletSpeed() {
            return this.bulletSpeed;
        }

        public int getBurnTime() {
            return this.burnTime;
        }
    }
}

