/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.network.packets;

import dev.hexnowloading.dungeonnowloading.network.ClientUtil;
import dev.hexnowloading.dungeonnowloading.network.DNLPacket;
import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import dev.hexnowloading.dungeonnowloading.sound.TickingSoundTarget;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class S2CFadeInTickingSoundPacket
implements DNLPacket {
    private final int entityId;
    private final ResourceLocation soundId;
    private final TickingSoundTarget target;
    private final int tagId;
    private final float maxVolume;
    private final int fadeInTicks;

    public S2CFadeInTickingSoundPacket(int entityId, ResourceLocation soundId) {
        this(entityId, soundId, TickingSoundTarget.OLDEST, -1, 1.0f, 20);
    }

    public S2CFadeInTickingSoundPacket(int entityId, ResourceLocation soundId, float maxVolume, int fadeInTicks) {
        this(entityId, soundId, TickingSoundTarget.OLDEST, -1, maxVolume, fadeInTicks);
    }

    public S2CFadeInTickingSoundPacket(int entityId, ResourceLocation soundId, TickingSoundTarget target, float maxVolume, int fadeInTicks) {
        this(entityId, soundId, target, -1, maxVolume, fadeInTicks);
    }

    public S2CFadeInTickingSoundPacket(int entityId, ResourceLocation soundId, TickingSoundTarget target, int tagId, float maxVolume, int fadeInTicks) {
        this.entityId = entityId;
        this.soundId = soundId;
        this.target = target;
        this.tagId = tagId;
        this.maxVolume = maxVolume;
        this.fadeInTicks = fadeInTicks;
    }

    public S2CFadeInTickingSoundPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.soundId = buf.m_130281_();
        this.target = (TickingSoundTarget)buf.m_130066_(TickingSoundTarget.class);
        this.tagId = buf.m_130242_();
        this.maxVolume = buf.readFloat();
        this.fadeInTicks = buf.m_130242_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130085_(this.soundId);
        buf.m_130068_((Enum)this.target);
        buf.m_130130_(this.tagId);
        buf.writeFloat(this.maxVolume);
        buf.m_130130_(this.fadeInTicks);
    }

    public static S2CFadeInTickingSoundPacket decode(FriendlyByteBuf buf) {
        return new S2CFadeInTickingSoundPacket(buf);
    }

    @Override
    public void handle(@Nullable ServerPlayer sender) {
        if (sender != null) {
            return;
        }
        if (ClientUtil.onClient()) {
            DNLClientSoundHandler.fadeInTickingSound(this.soundId, this.entityId, this.target, this.tagId, this.maxVolume, this.fadeInTicks);
        }
    }
}

