/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.OrbitingObject;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;

public abstract class StarLike
extends OrbitingObject {
    public static final String MIN_STAR_SIZE = "min_star_size";
    public static final String MAX_STAR_ALPHA = "max_star_alpha";
    public static final String MIN_STAR_ALPHA = "min_star_alpha";
    public static final float MIN_SIZE = 0.08f;
    public static final float MAX_ALPHA = 1.0f;
    public static final float MIN_ALPHA = 0.1f;
    private float minStarSize;
    private float maxStarAlpha;
    private float minStarAlpha;

    public StarLike() {
    }

    public StarLike(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<OrbitingObject.OrbitInfo> orbitInfo, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler, float minStarSize, float maxStarAlpha, float minStarAlpha) {
        super(parent, coords, axisRotation, orbitInfo, textureLayers, fadeOutHandler);
        this.minStarSize = minStarSize;
        this.maxStarAlpha = maxStarAlpha;
        this.minStarAlpha = minStarAlpha;
    }

    public float getMinStarSize() {
        return this.minStarSize;
    }

    public float getMaxStarAlpha() {
        return this.maxStarAlpha;
    }

    public float getMinStarAlpha() {
        return this.minStarAlpha;
    }

    public float starSize(float size, double lyDistance) {
        if ((size = (float)((double)size - (double)size * lyDistance / 1000000.0)) < this.getMinStarSize()) {
            return this.getMinStarSize();
        }
        return size;
    }

    public Color.FloatRGBA starRGBA(double lyDistance) {
        float alpha = this.getMaxStarAlpha();
        if ((alpha = (float)((double)alpha - lyDistance / 100000.0)) < this.getMinStarAlpha()) {
            alpha = this.getMinStarAlpha();
        }
        return new Color.FloatRGBA(1.0f, 1.0f, 1.0f, alpha);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putFloat(MIN_STAR_SIZE, this.minStarSize);
        tag.putFloat(MAX_STAR_ALPHA, this.maxStarAlpha);
        tag.putFloat(MIN_STAR_ALPHA, this.minStarAlpha);
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.minStarSize = tag.getFloat(MIN_STAR_SIZE);
        this.maxStarAlpha = tag.getFloat(MAX_STAR_ALPHA);
        this.minStarAlpha = tag.getFloat(MIN_STAR_ALPHA);
    }

    public static class StarType
    implements INBTSerializable<CompoundTag> {
        public static final String RGB = "rgb";
        public static final String MIN_SIZE = "min_size";
        public static final String MAX_SIZE = "max_size";
        public static final String MIN_BRIGHTNESS = "min_brightness";
        public static final String MAX_BRIGHTNESS = "max_brightness";
        public static final String MAX_VISIBLE_DISTANCE = "max_visible_distance";
        public static final String WEIGHT = "weight";
        private Color.IntRGB rgb;
        private float minSize;
        private float maxSize;
        private short minBrightness;
        private short maxBrightness;
        public long maxVisibleDistance;
        public int weight;
        public static final Codec<StarType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Color.IntRGB.CODEC.fieldOf(RGB).forGetter(StarType::getRGB), (App)Codec.FLOAT.fieldOf(MIN_SIZE).forGetter(starType -> Float.valueOf(starType.minSize)), (App)Codec.FLOAT.fieldOf(MAX_SIZE).forGetter(starType -> Float.valueOf(starType.maxSize)), (App)Codec.SHORT.fieldOf(MIN_BRIGHTNESS).forGetter(starType -> starType.minBrightness), (App)Codec.SHORT.fieldOf(MAX_BRIGHTNESS).forGetter(starType -> starType.maxBrightness), (App)Codec.LONG.optionalFieldOf(MAX_VISIBLE_DISTANCE, (Object)Long.MAX_VALUE).forGetter(StarType::getMaxVisibleDistance), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf(WEIGHT).forGetter(StarType::getWeight)).apply((Applicative)instance, StarType::new));

        public StarType() {
        }

        public StarType(Color.IntRGB rgb, float minSize, float maxSize, short minBrightness, short maxBrightness, long maxVisibleDistance, int weight) {
            this.rgb = rgb;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.minBrightness = minBrightness;
            this.maxBrightness = maxBrightness;
            this.maxVisibleDistance = maxVisibleDistance;
            this.weight = weight;
        }

        public Color.IntRGB getRGB() {
            return this.rgb;
        }

        public int getWeight() {
            return this.weight;
        }

        public float randomSize(Random random) {
            if (this.minSize == this.maxSize) {
                return this.maxSize;
            }
            return random.nextFloat(this.minSize, this.maxSize);
        }

        public short randomBrightness(Random random) {
            if (this.minBrightness == this.maxBrightness) {
                return this.maxBrightness;
            }
            return (short)random.nextInt(this.minBrightness, this.maxBrightness + 1);
        }

        public long getMaxVisibleDistance() {
            return this.maxVisibleDistance;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.put(RGB, (Tag)this.rgb.serializeNBT(provider));
            tag.putFloat(MIN_SIZE, this.minSize);
            tag.putFloat(MAX_SIZE, this.maxSize);
            tag.putShort(MIN_BRIGHTNESS, this.minBrightness);
            tag.putShort(MAX_BRIGHTNESS, this.maxBrightness);
            tag.putLong(MAX_VISIBLE_DISTANCE, this.maxVisibleDistance);
            tag.putInt(WEIGHT, this.weight);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            this.rgb = new Color.IntRGB();
            this.rgb.deserializeNBT(provider, tag.getCompound(RGB));
            this.minSize = tag.getFloat(MIN_SIZE);
            this.maxSize = tag.getFloat(MAX_SIZE);
            this.minBrightness = tag.getShort(MIN_BRIGHTNESS);
            this.maxBrightness = tag.getShort(MAX_BRIGHTNESS);
            this.maxVisibleDistance = tag.getLong(MAX_VISIBLE_DISTANCE);
            this.weight = tag.getInt(WEIGHT);
        }
    }
}

