/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level;

import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.povstalec.stellarview.api.client.render.level.StellarViewSpecialEffects;
import net.povstalec.stellarview.common.config.OverworldConfig;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class StellarViewOverworldEffects
extends StellarViewSpecialEffects {
    public static final ResourceLocation OVERWORLD_EFFECTS = ResourceLocation.withDefaultNamespace((String)"overworld");
    public static final float TWILIGHT_START = 0.4f;
    protected final float[] sunriseCol = new float[4];

    public StellarViewOverworldEffects() {
        super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    @Override
    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float brightness) {
        return fogColor.multiply((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f));
    }

    @Nullable
    public float[] getSunriseColor(float timeOfDay, float partialTicks) {
        float sunXProjection = Mth.cos((float)(timeOfDay * ((float)Math.PI * 2)));
        if (sunXProjection >= -0.4f && sunXProjection <= 0.4f) {
            float sunProjectionA = sunXProjection / 0.4f * 0.5f + 0.5f;
            float sunProjectionB = 1.0f - (1.0f - Mth.sin((float)(sunProjectionA * (float)Math.PI))) * 0.99f;
            sunProjectionB *= sunProjectionB;
            this.sunriseCol[0] = sunProjectionA * 0.3f + 0.7f;
            this.sunriseCol[1] = sunProjectionA * sunProjectionA * 0.7f + 0.2f;
            this.sunriseCol[2] = sunProjectionA * sunProjectionA * 0.0f + 0.2f;
            this.sunriseCol[3] = sunProjectionB;
            return this.sunriseCol;
        }
        return null;
    }

    @Override
    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (OverworldConfig.replace_vanilla.get()) {
            return super.renderSky(level, ticks, partialTick, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog);
        }
        return false;
    }
}

