/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level.util;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;

public class StellarViewFogEffects {
    public static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
    }

    public static boolean isFoggy(Minecraft minecraft, Camera camera, ViewCenter viewCenter) {
        boolean isFoggy;
        Vec3 cameraPos = camera.getPosition();
        boolean isFoggyAt = viewCenter.fog().isFoggyAt(Mth.floor((double)cameraPos.x()), Mth.floor((double)cameraPos.y()));
        boolean isWorldFog = minecraft.gui.getBossOverlay().shouldCreateWorldFog();
        boolean bl = isFoggy = isFoggyAt || isWorldFog;
        if (isFoggy) {
            return true;
        }
        FogType fogtype = camera.getFluidInCamera();
        return fogtype == FogType.POWDER_SNOW || fogtype == FogType.LAVA || StellarViewFogEffects.doesMobEffectBlockSky(camera);
    }
}

