/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.shader;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.util.Lazy;

@EventBusSubscriber(modid="stellarview", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class StellarViewVertexFormat {
    public static final Lazy<VertexFormatElement> ELEMENT_HEIGHT_WIDTH_SIZE_DISTANCE = StellarViewVertexFormat.register(VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.GENERIC, 4);
    public static final Lazy<VertexFormat> STAR_POS_COLOR_LY = Lazy.of(() -> VertexFormat.builder().add("StarPos", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("HeightWidthSizeDistance", (VertexFormatElement)ELEMENT_HEIGHT_WIDTH_SIZE_DISTANCE.get()).build());
    public static final Lazy<VertexFormat> STAR_POS_COLOR_LY_TEX = Lazy.of(() -> VertexFormat.builder().add("StarPos", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("HeightWidthSizeDistance", (VertexFormatElement)ELEMENT_HEIGHT_WIDTH_SIZE_DISTANCE.get()).add("UV0", VertexFormatElement.UV0).build());

    private static Lazy<VertexFormatElement> register(VertexFormatElement.Type type, VertexFormatElement.Usage usage, int count) {
        return Lazy.of(() -> {
            int index = (int)VertexFormatElement.ELEMENTS.stream().filter(el -> el.usage().equals((Object)usage)).count();
            return VertexFormatElement.register((int)StellarViewVertexFormat.getNextVertexFormatElementId(), (int)index, (VertexFormatElement.Type)type, (VertexFormatElement.Usage)usage, (int)count);
        });
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ELEMENT_HEIGHT_WIDTH_SIZE_DISTANCE.get();
            STAR_POS_COLOR_LY.get();
            STAR_POS_COLOR_LY_TEX.get();
        });
    }

    private static int getNextVertexFormatElementId() {
        int id = VertexFormatElement.ELEMENTS.size();
        while (VertexFormatElement.byId((int)id) != null) {
            if (++id < 32) continue;
            throw new RuntimeException("Too many mods registering VertexFormatElements");
        }
        return id;
    }
}

