/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.UV;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class Skybox {
    public static final float DEFAULT_DISTANCE = 150.0f;
    public static final Vector3f[][] BOX_COORDS = new Vector3f[][]{{new Vector3f(-150.0f, 150.0f, 150.0f), new Vector3f(-150.0f, 150.0f, -150.0f), new Vector3f(150.0f, 150.0f, -150.0f), new Vector3f(150.0f, 150.0f, 150.0f)}, {new Vector3f(150.0f, 150.0f, 150.0f), new Vector3f(150.0f, -150.0f, 150.0f), new Vector3f(-150.0f, -150.0f, 150.0f), new Vector3f(-150.0f, 150.0f, 150.0f)}, {new Vector3f(-150.0f, 150.0f, 150.0f), new Vector3f(-150.0f, -150.0f, 150.0f), new Vector3f(-150.0f, -150.0f, -150.0f), new Vector3f(-150.0f, 150.0f, -150.0f)}, {new Vector3f(-150.0f, 150.0f, -150.0f), new Vector3f(-150.0f, -150.0f, -150.0f), new Vector3f(150.0f, -150.0f, -150.0f), new Vector3f(150.0f, 150.0f, -150.0f)}, {new Vector3f(150.0f, 150.0f, -150.0f), new Vector3f(150.0f, -150.0f, -150.0f), new Vector3f(150.0f, -150.0f, 150.0f), new Vector3f(150.0f, 150.0f, 150.0f)}, {new Vector3f(-150.0f, -150.0f, -150.0f), new Vector3f(-150.0f, -150.0f, 150.0f), new Vector3f(150.0f, -150.0f, 150.0f), new Vector3f(150.0f, -150.0f, -150.0f)}};
    private SkyboxFacade[] facades = new SkyboxFacade[6];
    public static final Codec<Skybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkyboxFacade.CODEC.fieldOf("top_facade").forGetter(Skybox::topFacade), (App)SkyboxFacade.CODEC.fieldOf("north_facade").forGetter(Skybox::northFacade), (App)SkyboxFacade.CODEC.fieldOf("east_facade").forGetter(Skybox::eastFacade), (App)SkyboxFacade.CODEC.fieldOf("south_facade").forGetter(Skybox::southFacade), (App)SkyboxFacade.CODEC.fieldOf("west_facade").forGetter(Skybox::westFacade), (App)SkyboxFacade.CODEC.fieldOf("bottom_facade").forGetter(Skybox::bottomFacade)).apply((Applicative)instance, Skybox::new));

    public Skybox(SkyboxFacade topFacade, SkyboxFacade northFacade, SkyboxFacade eastFacade, SkyboxFacade southFacade, SkyboxFacade westFacade, SkyboxFacade bottomFacade) {
        this.facades[0] = topFacade;
        this.facades[1] = northFacade;
        this.facades[2] = eastFacade;
        this.facades[3] = southFacade;
        this.facades[4] = westFacade;
        this.facades[5] = bottomFacade;
    }

    public SkyboxFacade topFacade() {
        return this.facades[0];
    }

    public SkyboxFacade northFacade() {
        return this.facades[1];
    }

    public SkyboxFacade eastFacade() {
        return this.facades[2];
    }

    public SkyboxFacade southFacade() {
        return this.facades[3];
    }

    public SkyboxFacade westFacade() {
        return this.facades[4];
    }

    public SkyboxFacade bottomFacade() {
        return this.facades[5];
    }

    public void render(ClientLevel level, float partialTicks, Matrix4f modelViewMatrix, Tesselator tesselator) {
        Matrix4f transformeModelView;
        Matrix4f lastMatrix = transformeModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < 6; ++i) {
            this.renderFacade(tesselator, lastMatrix, this.facades[i], i);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    protected void renderFacade(Tesselator tesselator, Matrix4f lastMatrix, SkyboxFacade facade, int i) {
        UV.Quad uv = facade.uv();
        Color.IntRGBA rgba = facade.rgba();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)facade.texture());
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(lastMatrix, Skybox.BOX_COORDS[i][0].x, Skybox.BOX_COORDS[i][0].y, Skybox.BOX_COORDS[i][0].z).setUv(uv.topLeft().u(), uv.topLeft().v()).setColor(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha());
        bufferbuilder.addVertex(lastMatrix, Skybox.BOX_COORDS[i][1].x, Skybox.BOX_COORDS[i][1].y, Skybox.BOX_COORDS[i][1].z).setUv(uv.bottomLeft().u(), uv.bottomLeft().v()).setColor(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha());
        bufferbuilder.addVertex(lastMatrix, Skybox.BOX_COORDS[i][2].x, Skybox.BOX_COORDS[i][2].y, Skybox.BOX_COORDS[i][2].z).setUv(uv.bottomRight().u(), uv.bottomRight().v()).setColor(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha());
        bufferbuilder.addVertex(lastMatrix, Skybox.BOX_COORDS[i][3].x, Skybox.BOX_COORDS[i][3].y, Skybox.BOX_COORDS[i][3].z).setUv(uv.topRight().u(), uv.topRight().v()).setColor(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha());
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    public static class SkyboxFacade {
        private final ResourceLocation texture;
        private final UV.Quad uv;
        private final Color.IntRGBA rgba;
        public static final Codec<SkyboxFacade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SkyboxFacade::texture), (App)UV.Quad.CODEC.fieldOf("uv").forGetter(SkyboxFacade::uv), (App)Color.IntRGBA.CODEC.fieldOf("rgba").forGetter(SkyboxFacade::rgba)).apply((Applicative)instance, SkyboxFacade::new));

        public SkyboxFacade(ResourceLocation texture, UV.Quad uv, Color.IntRGBA rgba) {
            this.texture = ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)("textures/" + texture.getPath()));
            this.uv = uv;
            this.rgba = rgba;
        }

        public ResourceLocation texture() {
            return this.texture;
        }

        public UV.Quad uv() {
            return this.uv;
        }

        public Color.IntRGBA rgba() {
            return this.rgba;
        }
    }
}

