/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.screens.config;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.povstalec.stellarview.client.screens.config.ConfigList;
import net.povstalec.stellarview.client.util.CelestialInstancedBuffer;
import net.povstalec.stellarview.common.config.GeneralConfig;

public class GeneralConfigScreen
extends Screen {
    private final Screen parentScreen;
    private ConfigList configList;
    private static final int BACK_BUTTON_WIDTH = 200;
    private static final int BACK_BUTTON_HEIGHT = 20;
    private static final int BACK_BUTTON_TOP_OFFSET = 26;
    private static final int OPTIONS_LIST_HEADER_HEIGHT = 24;
    private static final int OPTIONS_LIST_BOTTOM_OFFSET = 32;
    private static final int OPTIONS_LIST_ITEM_HEIGHT = 25;

    public GeneralConfigScreen(@Nullable Screen parentScreen) {
        super((Component)Component.translatable((String)"gui.stellarview.config.general"));
        this.parentScreen = parentScreen;
    }

    public void init() {
        super.init();
        this.configList = new ConfigList(this.minecraft, this.width, this.height - 24 - 32, 24, 25);
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.static_sky"), this.width, GeneralConfig.static_sky));
        if (CelestialInstancedBuffer.INSTANCING_PREREQUISITES) {
            this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.instancing"), this.width, GeneralConfig.instancing));
        }
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.alt_vertex_build_order"), this.width, GeneralConfig.alt_vertex_build_order));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.use_game_ticks"), this.width, GeneralConfig.use_game_ticks));
        this.configList.add(new ConfigList.SliderConfigEntry((Component)Component.translatable((String)"gui.stellarview.tick_multiplier").append((Component)Component.literal((String)": ")), (Component)Component.empty(), this.width, GeneralConfig.tick_multiplier));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.disable_view_center_rotation"), this.width, GeneralConfig.disable_view_center_rotation));
        this.configList.add(new ConfigList.SliderConfigEntry((Component)Component.translatable((String)"gui.stellarview.space_region_render_distance").append((Component)Component.literal((String)": ")), (Component)Component.empty(), this.width, GeneralConfig.space_region_render_distance));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.gravitational_lensing"), this.width, GeneralConfig.gravitational_lensing));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.dust_clouds"), this.width, GeneralConfig.dust_clouds));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.disable_stars"), this.width, GeneralConfig.disable_stars));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.textured_stars"), this.width, GeneralConfig.textured_stars));
        this.configList.add(new ConfigList.BooleanConfigEntry((Component)Component.translatable((String)"gui.stellarview.light_pollution"), this.width, GeneralConfig.light_pollution));
        this.configList.add(new ConfigList.SliderConfigEntry((Component)Component.translatable((String)"gui.stellarview.star_brightness").append((Component)Component.literal((String)": ")), (Component)Component.literal((String)"%"), this.width, GeneralConfig.star_brightness));
        this.configList.add(new ConfigList.SliderConfigEntry((Component)Component.translatable((String)"gui.stellarview.dust_cloud_brightness").append((Component)Component.literal((String)": ")), (Component)Component.literal((String)"%"), this.width, GeneralConfig.dust_cloud_brightness));
        this.addWidget((GuiEventListener)this.configList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> {
            if (this.parentScreen != null) {
                this.minecraft.setScreen(this.parentScreen);
            } else {
                this.onClose();
            }
        }).bounds((this.width - 200) / 2, this.height - 26, 200, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.configList.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawString(this.font, this.title, (this.width - this.font.width((FormattedText)this.title)) / 2, 8, 0xFFFFFF);
    }
}

