/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.common.config.AetherConfig;
import net.povstalec.stellarview.common.config.EndConfig;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.config.NetherConfig;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.common.config.TwilightForestConfig;

public class StellarViewConfig {
    private static final ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec CLIENT_CONFIG;

    public static void loadConfig(ModConfigSpec config, String path) {
        StellarView.LOGGER.info("Loading Config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        StellarView.LOGGER.info("Built config: " + path);
        file.load();
        StellarView.LOGGER.info("Loaded Config: " + path);
        config.correct((CommentedConfig)file);
    }

    private static void generalClientConfig(ModConfigSpec.Builder client) {
        CLIENT_BUILDER.push("General Config");
        GeneralConfig.init(client);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("Overworld Config");
        OverworldConfig.init(client);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("Nether Config");
        NetherConfig.init(client);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("End Config");
        EndConfig.init(client);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("Twilight Forest Config");
        TwilightForestConfig.init(client);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("Aether Config");
        AetherConfig.init(client);
        CLIENT_BUILDER.pop();
    }

    static {
        CLIENT_BUILDER.push("Stellar View Client Config");
        StellarViewConfig.generalClientConfig(CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

