/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.common.util.Color;

public class StarInfo
implements INBTSerializable<CompoundTag> {
    public static final String LOD1_TYPES = "lod1_types";
    public static final String LOD2_TYPES = "lod2_types";
    public static final String LOD3_TYPES = "lod3_types";
    public static final String LOD1_WEIGHT = "lod1_weight";
    public static final String LOD2_WEIGHT = "lod2_weight";
    public static final String LOD3_WEIGHT = "lod3_weight";
    private ArrayList<StarLike.StarType> lod1Types;
    private ArrayList<StarLike.StarType> lod2Types;
    private ArrayList<StarLike.StarType> lod3Types;
    private int lod1Weight = 0;
    private int lod2Weight = 0;
    private int lod3Weight = 0;
    public static final StarLike.StarType WHITE_STAR = new StarLike.StarType(new Color.IntRGB(255, 255, 255), 0.15f, 0.25f, 100, 255, 6000000L, 1);
    public static final List<StarLike.StarType> DEFAULT_STARS = Arrays.asList(WHITE_STAR);
    public static final StarInfo DEFAULT_STAR_INFO = new StarInfo(DEFAULT_STARS);
    public static final Codec<StarInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StarLike.StarType.CODEC.listOf().fieldOf("star_types").forGetter(starInfo -> new ArrayList())).apply((Applicative)instance, StarInfo::new));

    public StarInfo() {
    }

    public StarInfo(List<StarLike.StarType> starTypes) {
        block4: for (StarLike.StarType starType : starTypes) {
            switch (StarField.LevelOfDetail.fromDistance(starType.getMaxVisibleDistance())) {
                case LOD1: {
                    if (this.lod1Types == null) {
                        this.lod1Types = new ArrayList();
                    }
                    this.lod1Types.add(starType);
                    this.lod1Weight += starType.getWeight();
                    continue block4;
                }
                case LOD2: {
                    if (this.lod2Types == null) {
                        this.lod2Types = new ArrayList();
                    }
                    this.lod2Types.add(starType);
                    this.lod2Weight += starType.getWeight();
                    continue block4;
                }
            }
            if (this.lod3Types == null) {
                this.lod3Types = new ArrayList();
            }
            this.lod3Types.add(starType);
            this.lod3Weight += starType.getWeight();
        }
    }

    public StarInfo(List<StarLike.StarType> lod1Types, List<StarLike.StarType> lod2Types, List<StarLike.StarType> lod3Types, int lod1Weight, int lod2Weight, int lod3Weight) {
        if (lod1Types != null) {
            this.lod1Types = new ArrayList<StarLike.StarType>(lod1Types);
        }
        if (lod2Types != null) {
            this.lod2Types = new ArrayList<StarLike.StarType>(lod2Types);
        }
        if (lod3Types != null) {
            this.lod3Types = new ArrayList<StarLike.StarType>(lod3Types);
        }
        this.lod1Weight = lod1Weight;
        this.lod2Weight = lod2Weight;
        this.lod3Weight = lod3Weight;
    }

    private StarLike.StarType randomStarType(ArrayList<StarLike.StarType> lodTypes, int totalWeight, Random random) {
        int i;
        if (lodTypes == null || lodTypes.isEmpty()) {
            return WHITE_STAR;
        }
        int weight = random.nextInt(0, totalWeight);
        for (i = 0; i < lodTypes.size() - 1 && (weight -= lodTypes.get(i).getWeight()) > 0; ++i) {
        }
        return lodTypes.get(i);
    }

    public StarLike.StarType randomLOD1StarType(Random random) {
        return this.randomStarType(this.lod1Types, this.lod1Weight, random);
    }

    public StarLike.StarType randomLOD2StarType(Random random) {
        return this.randomStarType(this.lod2Types, this.lod2Weight, random);
    }

    public StarLike.StarType randomLOD3StarType(Random random) {
        return this.randomStarType(this.lod3Types, this.lod3Weight, random);
    }

    public int totalWeight() {
        return this.lod1Weight + this.lod2Weight + this.lod3Weight;
    }

    public int lod1Weight() {
        return this.lod1Weight;
    }

    public int lod2Weight() {
        return this.lod2Weight;
    }

    public int lod3Weight() {
        return this.lod3Weight;
    }

    private static CompoundTag serializeLODTypes(HolderLookup.Provider provider, ArrayList<StarLike.StarType> lodTypes) {
        CompoundTag starTypesTag = new CompoundTag();
        for (int i = 0; i < lodTypes.size(); ++i) {
            starTypesTag.put("star_type_" + i, (Tag)lodTypes.get(i).serializeNBT(provider));
        }
        return starTypesTag;
    }

    private static ArrayList<StarLike.StarType> getLODTypes(HolderLookup.Provider provider, CompoundTag tag, String key) {
        ArrayList<StarLike.StarType> lodTypes;
        if (tag.contains(key)) {
            lodTypes = new ArrayList<StarLike.StarType>();
            CompoundTag starTypesTag = tag.getCompound(key);
            for (int i = 0; i < starTypesTag.size(); ++i) {
                StarLike.StarType starType = new StarLike.StarType();
                starType.deserializeNBT(provider, starTypesTag.getCompound("star_type_" + i));
                lodTypes.add(starType);
            }
        } else {
            lodTypes = null;
        }
        return lodTypes;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.lod1Types != null) {
            tag.put(LOD1_TYPES, (Tag)StarInfo.serializeLODTypes(provider, this.lod1Types));
        }
        if (this.lod2Types != null) {
            tag.put(LOD2_TYPES, (Tag)StarInfo.serializeLODTypes(provider, this.lod2Types));
        }
        if (this.lod3Types != null) {
            tag.put(LOD3_TYPES, (Tag)StarInfo.serializeLODTypes(provider, this.lod3Types));
        }
        tag.putInt(LOD1_WEIGHT, this.lod1Weight);
        tag.putInt(LOD2_WEIGHT, this.lod2Weight);
        tag.putInt(LOD3_WEIGHT, this.lod3Weight);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.lod1Types = StarInfo.getLODTypes(provider, tag, LOD1_TYPES);
        this.lod2Types = StarInfo.getLODTypes(provider, tag, LOD2_TYPES);
        this.lod3Types = StarInfo.getLODTypes(provider, tag, LOD3_TYPES);
        this.lod1Weight = tag.getInt(LOD1_WEIGHT);
        this.lod2Weight = tag.getInt(LOD2_WEIGHT);
        this.lod3Weight = tag.getInt(LOD3_WEIGHT);
    }
}

