/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.UV;

public class TextureLayer
implements INBTSerializable<CompoundTag> {
    public static final String TEXTURE = "texture";
    public static final String RGBA = "rgba";
    public static final String BLEND = "blend";
    public static final String SIZE = "size";
    public static final String MIN_SIZE = "min_size";
    public static final String CLAMP_AT_MIN_SIZE = "clamp_at_min_size";
    public static final String MAX_SIZE = "max_size";
    public static final String CLAMP_AT_MAX_SIZE = "clamp_at_max_size";
    public static final String ROTATION = "rotation";
    public static final String UV_QUAD = "uv";
    public static final double MIN_VISUAL_SIZE = 0.05;
    public static final double MAX_VISUAL_SIZE = Double.MAX_VALUE;
    private ResourceLocation texture;
    private Color.FloatRGBA rgba;
    private boolean blend;
    private double size;
    private double minSize;
    private boolean clampAtMinSize;
    private double maxSize;
    private boolean clampAtMaxSize;
    private double rotation;
    private UV.Quad uv;
    public static final Codec<TextureLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(TEXTURE).forGetter(TextureLayer::texture), (App)Color.FloatRGBA.INT_CODEC.fieldOf(RGBA).forGetter(TextureLayer::rgba), (App)Codec.BOOL.fieldOf(BLEND).forGetter(TextureLayer::shoulBlend), (App)Codec.DOUBLE.fieldOf(SIZE).forGetter(TextureLayer::size), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf(MIN_SIZE, (Object)0.05).forGetter(TextureLayer::minSize), (App)Codec.BOOL.optionalFieldOf(CLAMP_AT_MIN_SIZE, (Object)false).forGetter(TextureLayer::clampAtMinSize), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf(MAX_SIZE, (Object)Double.MAX_VALUE).forGetter(TextureLayer::maxSize), (App)Codec.BOOL.optionalFieldOf(CLAMP_AT_MAX_SIZE, (Object)false).forGetter(TextureLayer::clampAtMaxSize), (App)Codec.DOUBLE.fieldOf(ROTATION).forGetter(TextureLayer::rotation), (App)UV.Quad.CODEC.optionalFieldOf(UV_QUAD, (Object)UV.Quad.DEFAULT_QUAD_UV).forGetter(TextureLayer::uv)).apply((Applicative)instance, TextureLayer::new));

    public TextureLayer() {
    }

    public TextureLayer(ResourceLocation texture, Color.FloatRGBA rgba, boolean blend, double size, double minSize, boolean clampAtMinSize, double maxSize, boolean clampAtMaxSize, double rotation, UV.Quad uv) {
        this.texture = texture;
        this.rgba = rgba;
        this.blend = blend;
        this.size = size;
        this.minSize = minSize;
        this.clampAtMinSize = clampAtMinSize;
        this.maxSize = maxSize;
        this.clampAtMaxSize = clampAtMaxSize;
        this.rotation = Math.toRadians(rotation);
        this.uv = uv;
    }

    public ResourceLocation texture() {
        return this.texture;
    }

    public Color.FloatRGBA rgba() {
        return this.rgba;
    }

    public boolean shoulBlend() {
        return this.blend;
    }

    public double size() {
        return this.size;
    }

    public double minSize() {
        return this.minSize;
    }

    public boolean clampAtMinSize() {
        return this.clampAtMinSize;
    }

    public double maxSize() {
        return this.maxSize;
    }

    public boolean clampAtMaxSize() {
        return this.clampAtMaxSize;
    }

    public double mulSize(double mulSize) {
        return this.size * mulSize;
    }

    public double rotation() {
        return this.rotation;
    }

    public double rotation(double addRotation) {
        return this.rotation + addRotation;
    }

    public UV.Quad uv() {
        return this.uv;
    }

    public String toString() {
        return this.texture.toString();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putString(TEXTURE, this.texture.toString());
        tag.put(RGBA, (Tag)this.rgba.serializeNBT(provider));
        tag.putBoolean(BLEND, this.blend);
        tag.putDouble(SIZE, this.size);
        tag.putDouble(MIN_SIZE, this.minSize);
        tag.putBoolean(CLAMP_AT_MIN_SIZE, this.clampAtMinSize);
        tag.putDouble(MAX_SIZE, this.maxSize);
        tag.putBoolean(CLAMP_AT_MAX_SIZE, this.clampAtMaxSize);
        tag.putDouble(ROTATION, this.rotation);
        tag.put(UV_QUAD, (Tag)this.uv.serialize());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        Color.FloatRGBA rgba = new Color.FloatRGBA(0, 0, 0);
        rgba.deserializeNBT(provider, tag.getCompound(RGBA));
        this.texture = ResourceLocation.tryParse((String)tag.getString(TEXTURE));
        this.rgba = new Color.FloatRGBA(0, 0, 0);
        rgba.deserializeNBT(provider, tag.getCompound(RGBA));
        this.blend = tag.getBoolean(BLEND);
        this.size = tag.getDouble(SIZE);
        this.minSize = tag.getDouble(MIN_SIZE);
        this.clampAtMinSize = tag.getBoolean(CLAMP_AT_MIN_SIZE);
        this.maxSize = tag.getDouble(MAX_SIZE);
        this.clampAtMaxSize = tag.getBoolean(CLAMP_AT_MAX_SIZE);
        this.rotation = tag.getDouble(ROTATION);
        this.uv = UV.Quad.deserialize(tag.getCompound(UV_QUAD));
    }
}

