/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.compatibility.enhancedcelestials;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.client.ColorSettings;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.client.ECWorldRenderer;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.povstalec.stellarview.client.render.level.util.StellarViewLightmapEffects;
import net.povstalec.stellarview.common.util.Color;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EnhancedCelestialsCompatibility {
    public static final float getMoonSize(ClientLevel level, float defaultSize) {
        return ECWorldRenderer.getMoonSize((float)defaultSize);
    }

    public static final Color.FloatRGBA getMoonColor(ClientLevel level, float partialTicks) {
        AtomicReference<Color.FloatRGBA> result = new AtomicReference<Color.FloatRGBA>(new Color.FloatRGBA(1, 1, 1));
        EnhancedCelestials.lunarForecastWorldData((Level)level).ifPresent(data -> {
            ColorSettings lastColorSettings = ((LunarEvent)data.lastLunarEventHolder().value()).getClientSettings().colorSettings();
            ColorSettings currentColorSettings = ((LunarEvent)data.currentLunarEventHolder().value()).getClientSettings().colorSettings();
            Vector3f lastGLColor = lastColorSettings.getGLMoonColor();
            Vector3f currentGLColor = currentColorSettings.getGLMoonColor();
            float blend = data.getBlend();
            float r = Mth.clampedLerp((float)lastGLColor.x(), (float)currentGLColor.x(), (float)blend);
            float g = Mth.clampedLerp((float)lastGLColor.y(), (float)currentGLColor.y(), (float)blend);
            float b = Mth.clampedLerp((float)lastGLColor.z(), (float)currentGLColor.z(), (float)blend);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)(1.0f - level.getRainLevel(partialTicks)));
            result.set(new Color.FloatRGBA(r > 1.0f ? 1.0f : r, g > 1.0f ? 1.0f : g, b > 1.0f ? 1.0f : b));
        });
        return result.get();
    }

    public static final void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        float darkMultiplier = StellarViewLightmapEffects.getSkyDarken(level, 1.0f);
        boolean darkerWorld = true;
        if (darkerWorld) {
            float trueSkyDarken = level.getSkyFlashTime() > 0 ? 1.0f : darkMultiplier * 0.95f + 0.05f;
            Vector3f skyVector = new Vector3f(trueSkyDarken, trueSkyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            EnhancedCelestials.lunarForecastWorldData((Level)level).ifPresent(data -> {
                LunarEvent lastEvent = data.lastLunarEvent();
                LunarEvent currentEvent = data.currentLunarEvent();
                ColorSettings colorSettings = currentEvent.getClientSettings().colorSettings();
                ColorSettings lastColorSettings = lastEvent.getClientSettings().colorSettings();
                Vector3f glSkyLightColor = lastColorSettings.getGLSkyLightColor();
                Vector3f targetColor = new Vector3f(glSkyLightColor.x(), glSkyLightColor.y(), glSkyLightColor.z());
                float eventBlend = data.getBlend() - skyDarken;
                targetColor.lerp((Vector3fc)colorSettings.getGLSkyLightColor(), eventBlend);
                float skyBlend = 1.0f - skyDarken - level.getRainLevel(partialTicks);
                skyVector.lerp((Vector3fc)targetColor, skyBlend);
            });
            Vector3f lightColor = new Vector3f();
            float naturalLight = LightTexture.getBrightness((DimensionType)level.dimensionType(), (int)pixelY) * trueSkyDarken;
            float artificialLight = LightTexture.getBrightness((DimensionType)level.dimensionType(), (int)pixelX) * skyLight;
            float f10 = artificialLight * ((artificialLight * 0.6f + 0.4f) * 0.6f + 0.4f);
            float f11 = artificialLight * (artificialLight * artificialLight * 0.6f + 0.4f);
            lightColor.set(artificialLight, f10, f11);
            if (level.effects().forceBrightLightmap()) {
                lightColor.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                StellarViewLightmapEffects.clampColor(lightColor);
            } else {
                Minecraft minecraft = Minecraft.getInstance();
                Vector3f vector3f2 = new Vector3f((Vector3fc)skyVector).mul(naturalLight);
                lightColor.add((Vector3fc)vector3f2);
                lightColor.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (minecraft.gameRenderer.getDarkenWorldAmount(partialTicks) > 0.0f) {
                    float f12 = minecraft.gameRenderer.getDarkenWorldAmount(partialTicks);
                    Vector3f vector3f3 = new Vector3f((Vector3fc)lightColor).mul(0.7f, 0.6f, 0.6f);
                    lightColor.lerp((Vector3fc)vector3f3, f12);
                }
            }
            colors.set((Vector3fc)lightColor);
        }
    }
}

