/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;

public class Nebula
extends TexturedObject {
    public static final String MIN_NEBULA_SIZE = "min_nebula_size";
    public static final String MAX_NEBULA_ALPHA = "max_nebula_alpha";
    public static final String MIN_NEBULA_ALPHA = "min_nebula_alpha";
    public static final float MIN_SIZE = 0.4f;
    public static final float MAX_ALPHA = 1.0f;
    public static final float MIN_ALPHA = 0.1f;
    private float minNebulaSize;
    private float maxNebulaAlpha;
    private float minNebulaAlpha;
    public static final Codec<Nebula> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(TexturedObject::getTextureLayers), (App)TexturedObject.FadeOutHandler.CODEC.optionalFieldOf("fade_out_handler", (Object)TexturedObject.FadeOutHandler.DEFAULT_NEBULA_HANDLER).forGetter(TexturedObject::getFadeOutHandler), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf(MIN_NEBULA_SIZE, (Object)Float.valueOf(0.4f)).forGetter(Nebula::getMinNebulaSize), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf(MAX_NEBULA_ALPHA, (Object)Float.valueOf(1.0f)).forGetter(Nebula::getMaxNebulaAlpha), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf(MIN_NEBULA_ALPHA, (Object)Float.valueOf(0.1f)).forGetter(Nebula::getMinNebulaAlpha)).apply((Applicative)instance, Nebula::new));

    public Nebula() {
    }

    public Nebula(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, List<TextureLayer> textureLayers, TexturedObject.FadeOutHandler fadeOutHandler, float minNebulaSize, float maxNebulaAlpha, float minNebulaAlpha) {
        super(parent, coords, axisRotation, textureLayers, fadeOutHandler);
        this.minNebulaSize = minNebulaSize;
        this.maxNebulaAlpha = maxNebulaAlpha;
        this.minNebulaAlpha = minNebulaAlpha;
    }

    public float getMinNebulaSize() {
        return this.minNebulaSize;
    }

    public float getMaxNebulaAlpha() {
        return this.maxNebulaAlpha;
    }

    public float getMinNebulaAlpha() {
        return this.minNebulaAlpha;
    }

    public float nebulaSize(float size, double lyDistance) {
        if ((size = (float)((double)size - (double)size * lyDistance / 1000000.0)) < this.getMinNebulaSize()) {
            return this.getMinNebulaSize();
        }
        return size;
    }

    public Color.FloatRGBA nebulaRGBA(double lyDistance) {
        float alpha = this.getMaxNebulaAlpha();
        if ((alpha = (float)((double)alpha - lyDistance / 100000.0)) < this.getMinNebulaAlpha()) {
            alpha = this.getMinNebulaAlpha();
        }
        return new Color.FloatRGBA(1.0f, 1.0f, 1.0f, alpha);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        tag.method_10548(MIN_NEBULA_SIZE, this.minNebulaSize);
        tag.method_10548(MAX_NEBULA_ALPHA, this.maxNebulaAlpha);
        tag.method_10548(MIN_NEBULA_ALPHA, this.minNebulaAlpha);
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.minNebulaSize = tag.method_10583(MIN_NEBULA_SIZE);
        this.maxNebulaAlpha = tag.method_10583(MAX_NEBULA_ALPHA);
        this.minNebulaAlpha = tag.method_10583(MIN_NEBULA_ALPHA);
    }
}

