/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_291;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.level.util.StellarViewFogEffects;
import net.povstalec.stellarview.client.render.level.util.StellarViewSkyEffects;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.render.space_objects.ViewObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.Skybox;
import net.povstalec.stellarview.client.resourcepack.effects.MeteorEffect;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.MinMax;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ViewCenter {
    public static final float DAY_MAX_BRIGHTNESS = 0.25f;
    public static final float DAY_MIN_VISIBLE_SIZE = 2.5f;
    public static final float DAY_MAX_VISIBLE_SIZE = 10.0f;
    protected int levelTicks = 0;
    protected boolean updateTicks = false;
    protected long ticks = 0L;
    protected long oldTicks;
    protected long dayTicks;
    protected long oldDayTicks = 0L;
    protected float starBrightness = 0.0f;
    protected float dustCloudBrightness = 0.0f;
    @Nullable
    protected class_5321<SpaceObject> viewCenterKey;
    @Nullable
    protected ViewObjectRenderer viewObject;
    @Nullable
    protected List<Skybox> skyboxes;
    protected DayBlending dayBlending;
    protected DayBlending sunDayBlending;
    protected class_310 minecraft = class_310.method_1551();
    @Nullable
    protected class_291 skyBuffer;
    @Nullable
    protected class_291 darkBuffer;
    protected SpaceCoords coords;
    protected AxisRotation axisRotation;
    protected long rotationPeriod;
    @Nullable
    protected final MeteorEffect.ShootingStar shootingStar;
    @Nullable
    protected final MeteorEffect.MeteorShower meteorShower;
    public final boolean createHorizon;
    public final boolean createVoid;
    protected final Stars stars;
    protected final Fog fog;
    public final int zRotationMultiplier;
    public static final Codec<ViewCenter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.RESOURCE_KEY_CODEC.optionalFieldOf("view_center").forGetter(ViewCenter::getViewCenterKey), (App)Skybox.CODEC.listOf().optionalFieldOf("skyboxes").forGetter(ViewCenter::getSkyboxes), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(ViewCenter::getAxisRotation), (App)Codec.LONG.optionalFieldOf("rotation_period", (Object)0L).forGetter(ViewCenter::getRotationPeriod), (App)DayBlending.CODEC.optionalFieldOf("day_blending", (Object)DayBlending.DAY_BLENDING).forGetter(viewCenter -> viewCenter.dayBlending), (App)DayBlending.CODEC.optionalFieldOf("sun_day_blending", (Object)DayBlending.SUN_DAY_BLENDING).forGetter(viewCenter -> viewCenter.sunDayBlending), (App)MeteorEffect.ShootingStar.CODEC.optionalFieldOf("shooting_star").forGetter(viewCenter -> Optional.ofNullable(viewCenter.shootingStar)), (App)MeteorEffect.MeteorShower.CODEC.optionalFieldOf("meteor_shower").forGetter(viewCenter -> Optional.ofNullable(viewCenter.meteorShower)), (App)Codec.BOOL.optionalFieldOf("create_horizon", (Object)true).forGetter(viewCenter -> viewCenter.createHorizon), (App)Codec.BOOL.optionalFieldOf("create_void", (Object)true).forGetter(viewCenter -> viewCenter.createVoid), (App)Stars.CODEC.optionalFieldOf("stars", (Object)new Stars()).forGetter(viewCenter -> viewCenter.stars), (App)Fog.CODEC.optionalFieldOf("fog", (Object)new Fog()).forGetter(viewCenter -> viewCenter.fog), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("z_rotation_multiplier", (Object)30000000).forGetter(viewCenter -> viewCenter.zRotationMultiplier)).apply((Applicative)instance, ViewCenter::new));

    public ViewCenter(Optional<class_5321<SpaceObject>> viewCenterKey, Optional<List<Skybox>> skyboxes, AxisRotation axisRotation, long rotationPeriod, DayBlending dayBlending, DayBlending sunDayBlending, Optional<MeteorEffect.ShootingStar> shootingStar, Optional<MeteorEffect.MeteorShower> meteorShower, boolean createHorizon, boolean createVoid, Stars stars, Fog fog, int zRotationMultiplier) {
        this.viewCenterKey = viewCenterKey.orElse(null);
        this.skyboxes = skyboxes.orElse(null);
        this.axisRotation = axisRotation;
        this.rotationPeriod = rotationPeriod;
        this.dayBlending = dayBlending;
        this.sunDayBlending = sunDayBlending;
        this.shootingStar = shootingStar.orElse(null);
        this.meteorShower = meteorShower.orElse(null);
        this.createHorizon = createHorizon;
        this.createVoid = createVoid;
        if (createHorizon) {
            this.skyBuffer = StellarViewSkyEffects.createLightSky();
        }
        if (createVoid) {
            this.darkBuffer = StellarViewSkyEffects.createDarkSky();
        }
        this.stars = stars;
        this.fog = fog;
        this.zRotationMultiplier = zRotationMultiplier;
    }

    public void setViewObjectRenderer(ViewObjectRenderer<?> object) {
        this.viewObject = object;
    }

    public boolean setViewObjectRenderer(HashMap<class_2960, SpaceObjectRenderer<?>> spaceObjects) {
        if (this.viewCenterKey != null) {
            if (spaceObjects.containsKey(this.viewCenterKey.method_29177())) {
                SpaceObjectRenderer<?> spaceObjectRenderer = spaceObjects.get(this.viewCenterKey.method_29177());
                if (spaceObjectRenderer instanceof ViewObjectRenderer) {
                    ViewObjectRenderer viewObject = (ViewObjectRenderer)spaceObjectRenderer;
                    this.setViewObjectRenderer(viewObject);
                } else {
                    StellarView.LOGGER.error("Failed to register View Center because " + this.viewCenterKey.method_29177() + " is not an instance of ViewCenterObject");
                }
                return true;
            }
            StellarView.LOGGER.error("Failed to register View Center because view center object " + this.viewCenterKey.method_29177() + " could not be found");
            return false;
        }
        return true;
    }

    public boolean isStatic() {
        return GeneralConfig.static_sky.get();
    }

    public long ticks() {
        return this.ticks;
    }

    public long tickDifference() {
        return this.ticks - this.oldTicks;
    }

    public long dayTicks() {
        return this.dayTicks;
    }

    public long dayTickDifference() {
        return this.dayTicks - this.oldDayTicks;
    }

    public float starBrightness() {
        return this.starBrightness;
    }

    public float dustCloudBrightness() {
        return this.dustCloudBrightness;
    }

    public AxisRotation getObjectAxisRotation() {
        if (this.viewObject != null) {
            return this.viewObject.axisRotation();
        }
        return new AxisRotation();
    }

    public Optional<class_5321<SpaceObject>> getViewCenterKey() {
        if (this.viewCenterKey != null) {
            return Optional.of(this.viewCenterKey);
        }
        return Optional.empty();
    }

    public Optional<List<Skybox>> getSkyboxes() {
        if (this.skyboxes != null) {
            return Optional.of(this.skyboxes);
        }
        return Optional.empty();
    }

    public DayBlending dayBlending() {
        return this.dayBlending;
    }

    public DayBlending sunDayBlending() {
        return this.sunDayBlending;
    }

    public SpaceCoords getCoords() {
        return this.coords;
    }

    public void addCoords(SpaceCoords other) {
        this.coords = this.coords.add(other);
    }

    public void addCoords(Vector3f vector) {
        this.coords = this.coords.add(vector);
    }

    public void subCoords(SpaceCoords other) {
        this.coords = this.coords.sub(other);
    }

    public AxisRotation getAxisRotation() {
        return this.axisRotation;
    }

    public long getRotationPeriod() {
        return this.rotationPeriod;
    }

    public Stars stars() {
        return this.stars;
    }

    public Fog fog() {
        return this.fog;
    }

    public double zRotationMultiplier() {
        return this.zRotationMultiplier;
    }

    public double getZRotation(class_638 level, class_4184 camera, float partialTicks) {
        double zRotationMultiplier = this.zRotationMultiplier();
        if (zRotationMultiplier == 0.0) {
            return 0.0;
        }
        double zPos = camera.method_19331().method_30950(partialTicks).method_10215();
        return 2.0 * Math.atan(zPos / zRotationMultiplier);
    }

    @Nullable
    public MeteorEffect.ShootingStar getShootingStar() {
        return this.shootingStar;
    }

    @Nullable
    public MeteorEffect.MeteorShower getMeteorShower() {
        return this.meteorShower;
    }

    public boolean overrideMeteorEffects() {
        return false;
    }

    public double overrideShootingStarRarity() {
        return 10.0;
    }

    public double overrideMeteorShowerRarity() {
        return 10.0;
    }

    public boolean objectEquals(SpaceObjectRenderer spaceObject) {
        if (this.viewObject != null) {
            return spaceObject == this.viewObject;
        }
        return false;
    }

    protected boolean renderSkybox(class_638 level, float partialTicks, class_4587 stack, class_287 bufferbuilder) {
        if (this.skyboxes == null) {
            return false;
        }
        for (Skybox skybox : this.skyboxes) {
            skybox.render(level, partialTicks, stack, bufferbuilder);
        }
        return true;
    }

    protected void renderSkyEvents(class_638 level, class_4184 camera, float partialTicks, class_4587 stack, class_287 bufferbuilder) {
        if (this.shootingStar != null) {
            this.shootingStar.render(this, level, camera, partialTicks, stack, bufferbuilder);
        }
        if (this.meteorShower != null) {
            this.meteorShower.render(this, level, camera, partialTicks, stack, bufferbuilder);
        }
    }

    protected float getTimeOfDay(float partialTicks) {
        if (this.rotationPeriod <= 0L) {
            return 0.0f;
        }
        double d0 = class_3532.method_15385((double)((double)((float)(this.oldDayTicks % this.rotationPeriod) + (float)this.dayTickDifference() * partialTicks) / (double)this.rotationPeriod - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    protected boolean renderSkyObjectsFrom(class_638 level, class_4184 camera, float partialTicks, class_4587 stack, Matrix4f projectionMatrix, Runnable setupFog, class_287 bufferbuilder) {
        if (this.viewObject == null) {
            return false;
        }
        this.coords = this.viewObject.spaceCoords();
        if (this.updateTicks) {
            this.oldTicks = this.ticks;
            this.ticks = (long)GeneralConfig.tick_multiplier.get() * (GeneralConfig.use_game_ticks.get() ? level.method_8510() : level.method_8532());
        }
        this.starBrightness = LightEffects.starBrightness(this, level, camera, partialTicks);
        this.dustCloudBrightness = GeneralConfig.dust_clouds.get() ? LightEffects.dustCloudBrightness(this, level, camera, partialTicks) : 0.0f;
        stack.method_22903();
        if (!GeneralConfig.disable_view_center_rotation.get()) {
            if (this.updateTicks) {
                this.oldDayTicks = this.dayTicks;
                this.dayTicks = level.method_8532();
            }
            double rotation = Math.PI * 2 * (double)this.getTimeOfDay(partialTicks) + Math.PI;
            if (this.viewObject.orbitInfo() != null) {
                rotation -= this.viewObject.orbitInfo().meanAnomaly(this.ticks % this.viewObject.orbitInfo().orbitalPeriod().ticks(), (float)this.tickDifference() * partialTicks);
            }
            stack.method_22907(class_7833.field_40716.rotation((float)this.getAxisRotation().yAxis()));
            stack.method_22907(class_7833.field_40718.rotation((float)this.getAxisRotation().zAxis()));
            stack.method_22907(class_7833.field_40714.rotation((float)this.getAxisRotation().xAxis()));
            stack.method_22907(class_7833.field_40716.rotation((float)rotation));
            stack.method_22907(class_7833.field_40718.rotation((float)this.getZRotation(level, camera, partialTicks)));
        }
        this.viewObject.renderFrom(this, level, (float)this.tickDifference() * partialTicks, stack, camera, projectionMatrix, StellarViewFogEffects.isFoggy(this.minecraft, camera, this), setupFog, bufferbuilder);
        stack.method_22909();
        RenderSystem.setShader(class_757::method_34542);
        this.renderSkyEvents(level, camera, partialTicks, stack, bufferbuilder);
        return true;
    }

    public void renderSkyObjects(SpaceObjectRenderer masterParent, class_638 level, float partialTicks, class_4587 stack, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, class_287 bufferbuilder) {
        SpaceRenderer.render(this, masterParent, level, camera, partialTicks, stack, projectionMatrix, isFoggy, setupFog, bufferbuilder);
    }

    public boolean renderSky(class_638 level, int ticks, float partialTicks, class_4587 stack, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        this.minecraft.method_16011().method_15396("stellarview");
        if (this.viewObject == null && this.skyboxes == null) {
            return false;
        }
        if (this.levelTicks != ticks) {
            this.updateTicks = true;
            this.levelTicks = ticks;
        }
        setupFog.run();
        if (this.stars().ignoreFog() || !StellarViewFogEffects.isFoggy(this.minecraft, camera, this)) {
            double height;
            class_243 skyColor = level.method_23777(this.minecraft.field_1773.method_19418().method_19326(), partialTicks);
            float skyX = (float)skyColor.field_1352;
            float skyY = (float)skyColor.field_1351;
            float skyZ = (float)skyColor.field_1350;
            class_758.method_3212();
            class_287 bufferbuilder = class_289.method_1348().method_1349();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
            class_5944 shaderinstance = RenderSystem.getShader();
            if (this.createHorizon) {
                this.skyBuffer.method_1353();
                this.skyBuffer.method_34427(stack.method_23760().method_23761(), projectionMatrix, shaderinstance);
            }
            class_291.method_1354();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            StellarViewSkyEffects.renderSunrise(level, partialTicks, stack, projectionMatrix, bufferbuilder);
            RenderSystem.setShader(class_757::method_34542);
            this.renderSkybox(level, partialTicks, stack, bufferbuilder);
            RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
            this.renderSkyObjectsFrom(level, camera, partialTicks, stack, projectionMatrix, setupFog, bufferbuilder);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (this.createVoid && (height = this.minecraft.field_1724.method_5836((float)partialTicks).field_1351 - level.method_28104().method_28105((class_5539)level)) < 0.0) {
                stack.method_22903();
                stack.method_46416(0.0f, 12.0f, 0.0f);
                this.darkBuffer.method_1353();
                this.darkBuffer.method_34427(stack.method_23760().method_23761(), projectionMatrix, shaderinstance);
                class_291.method_1354();
                stack.method_22909();
            }
            if (level.method_28103().method_28113()) {
                RenderSystem.setShaderColor((float)(skyX * 0.2f + 0.04f), (float)(skyY * 0.2f + 0.04f), (float)(skyZ * 0.6f + 0.1f), (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        if (this.updateTicks) {
            this.updateTicks = false;
        }
        this.minecraft.method_16011().method_15407();
        return true;
    }

    public static class DayBlending {
        public static final DayBlending DAY_BLENDING = new DayBlending(1.0f, 10.0f, 30.0f);
        public static final DayBlending SUN_DAY_BLENDING = new DayBlending(1.0f, 10.0f, 20.0f);
        private final float dayMaxBrightness;
        private final float dayMinVisibleSize;
        private final float dayMaxVisibleSize;
        public static final Codec<DayBlending> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("max_brightness", (Object)Float.valueOf(0.25f)).forGetter(dayBlending -> Float.valueOf(dayBlending.dayMinVisibleSize)), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("min_visible_size", (Object)Float.valueOf(2.5f)).forGetter(dayBlending -> Float.valueOf(dayBlending.dayMinVisibleSize)), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("max_visible_size", (Object)Float.valueOf(10.0f)).forGetter(dayBlending -> Float.valueOf(dayBlending.dayMaxVisibleSize))).apply((Applicative)instance, DayBlending::new));

        public DayBlending(float dayMaxBrightness, float dayMinVisibleSize, float dayMaxVisibleSize) {
            this.dayMaxBrightness = dayMaxBrightness;
            this.dayMinVisibleSize = dayMinVisibleSize;
            this.dayMaxVisibleSize = dayMaxVisibleSize;
        }

        public float dayMaxBrightness() {
            return this.dayMaxBrightness;
        }

        public float dayMaxVisibleSize() {
            return this.dayMaxVisibleSize;
        }

        public float dayMinVisibleSize() {
            return this.dayMinVisibleSize;
        }

        public float dayVisibleRange() {
            return this.dayMaxVisibleSize - this.dayMinVisibleSize;
        }
    }

    public static class Stars {
        protected final boolean duringDay;
        protected final boolean ignoreFog;
        protected final boolean ignoreRain;
        public static final Codec<Stars> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("during_day", (Object)false).forGetter(stars -> stars.duringDay), (App)Codec.BOOL.optionalFieldOf("ignore_fog", (Object)false).forGetter(stars -> stars.ignoreFog), (App)Codec.BOOL.optionalFieldOf("ignore_rain", (Object)false).forGetter(stars -> stars.ignoreRain)).apply((Applicative)instance, Stars::new));

        public Stars(boolean duringDay, boolean ignoreFog, boolean ignoreRain) {
            this.duringDay = duringDay;
            this.ignoreFog = ignoreFog;
            this.ignoreRain = ignoreRain;
        }

        public Stars() {
            this(false, false, false);
        }

        public boolean duringDay() {
            return this.duringDay;
        }

        public boolean ignoreRain() {
            return this.ignoreRain;
        }

        public boolean ignoreFog() {
            return this.ignoreFog;
        }
    }

    public static class Fog {
        protected List<MinMax> height;
        public static final Codec<Fog> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MinMax.CODEC.listOf().optionalFieldOf("height", List.of()).forGetter(fog -> fog.height)).apply((Applicative)instance, Fog::new));

        public Fog(List<MinMax> height) {
            this.height = height;
        }

        public Fog() {
            this(List.of());
        }

        public boolean isFoggyAt(int x, int y) {
            for (MinMax minMax : this.height) {
                if (!minMax.isInBounds(y)) continue;
                return true;
            }
            return false;
        }
    }
}

