/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack.effects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;
import net.povstalec.stellarview.common.util.UV;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class MeteorEffect {
    public static final UV.Quad UV = new UV.Quad(false);
    public static final float DEFAULT_DISTANCE = 100.0f;
    public static final SphericalCoords SPHERICAL_START = new SphericalCoords(100.0, 0.0, 0.0);
    protected final ArrayList<MeteorType> meteorTypes;
    protected int totalWeight = 0;
    protected double rarity;

    public MeteorEffect(List<MeteorType> meteorTypes, double rarity) {
        this.meteorTypes = new ArrayList<MeteorType>(meteorTypes);
        this.rarity = rarity;
        for (MeteorType meteorType : meteorTypes) {
            this.totalWeight += meteorType.getWeight();
        }
    }

    public List<MeteorType> getMeteorTypes() {
        return this.meteorTypes;
    }

    public boolean canRender(ViewCenter viewCenter) {
        return this.getRarity(viewCenter) > 0.0 && this.meteorTypes.size() > 0;
    }

    public abstract double getRarity(ViewCenter var1);

    public double getRarity() {
        return this.rarity;
    }

    protected boolean shouldAppear(ViewCenter viewCenter, long seed) {
        Random random = new Random(seed);
        return random.nextDouble() <= this.getRarity(viewCenter);
    }

    protected MeteorType getRandomMeteorType(long seed) {
        int i;
        Random random = new Random(seed);
        int weight = random.nextInt(0, this.totalWeight);
        for (i = 0; i < this.meteorTypes.size() - 1 && (weight -= this.meteorTypes.get(i).getWeight()) > 0; ++i) {
        }
        return this.meteorTypes.get(i);
    }

    public Color.FloatRGBA rgba(ViewCenter viewCenter, class_638 level, class_4184 camera, long ticks, float partialTicks) {
        float brightness = LightEffects.getStarBrightness(viewCenter, level, camera, partialTicks) / 2.0f;
        return new Color.FloatRGBA(1.0f, 1.0f, 1.0f, brightness *= LightEffects.rainDimming(level, partialTicks));
    }

    public abstract void render(ViewCenter var1, class_638 var2, class_4184 var3, float var4, class_4587 var5, class_287 var6);

    public void render(ViewCenter viewCenter, class_638 level, class_4184 camera, float partialTicks, class_4587 stack, class_287 bufferbuilder, float xRotation, float yRotation, float zRotation, MeteorType meteorType, float mulSize, float addRotation) {
        stack.method_22903();
        stack.method_22907(class_7833.field_40716.rotationDegrees(yRotation));
        stack.method_22907(class_7833.field_40718.rotationDegrees(zRotation));
        stack.method_22907(class_7833.field_40714.rotationDegrees(xRotation));
        meteorType.render(bufferbuilder, stack.method_23760().method_23761(), SPHERICAL_START, this.rgba(viewCenter, level, camera, viewCenter.ticks(), partialTicks), viewCenter.ticks(), mulSize, addRotation);
        stack.method_22909();
    }

    public static class MeteorType {
        private final ArrayList<TextureLayer> textureLayers;
        private final int weight;
        public static final Codec<MeteorType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TextureLayer.CODEC.listOf().fieldOf("texture_layers").forGetter(MeteorType::getTextureLayers), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight").forGetter(MeteorType::getWeight)).apply((Applicative)instance, MeteorType::new));

        public MeteorType(List<TextureLayer> textureLayers, int weight) {
            this.textureLayers = new ArrayList<TextureLayer>(textureLayers);
            this.weight = weight;
        }

        public ArrayList<TextureLayer> getTextureLayers() {
            return this.textureLayers;
        }

        public int getWeight() {
            return this.weight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void renderTextureLayer(TextureLayer textureLayer, class_287 bufferbuilder, Matrix4f lastMatrix, SphericalCoords sphericalCoords, Color.FloatRGBA rgba, long ticks, float mulSize, float addRotation) {
            if (rgba.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
                return;
            }
            float size = (float)textureLayer.mulSize(mulSize);
            if ((double)size < textureLayer.minSize()) {
                if (!textureLayer.clampAtMinSize()) return;
                size = (float)textureLayer.minSize();
            } else if ((double)size > textureLayer.maxSize()) {
                if (!textureLayer.clampAtMaxSize()) return;
                size = (float)textureLayer.maxSize();
            }
            float rotation = (float)textureLayer.rotation();
            Vector3f corner00 = StellarCoordinates.placeOnSphere(-size, -size, sphericalCoords, rotation);
            Vector3f corner10 = StellarCoordinates.placeOnSphere(size, -size, sphericalCoords, rotation);
            Vector3f corner11 = StellarCoordinates.placeOnSphere(size, size, sphericalCoords, rotation);
            Vector3f corner01 = StellarCoordinates.placeOnSphere(-size, size, sphericalCoords, rotation);
            if (textureLayer.shoulBlend()) {
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            }
            RenderSystem.setShaderColor((float)(rgba.red() * textureLayer.rgba().red()), (float)(rgba.green() * textureLayer.rgba().green()), (float)(rgba.blue() * textureLayer.rgba().blue()), (float)(rgba.alpha() * textureLayer.rgba().alpha()));
            RenderSystem.setShaderTexture((int)0, (class_2960)textureLayer.texture());
            bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferbuilder.method_22918(lastMatrix, corner00.x, corner00.y, corner00.z).method_22913(textureLayer.uv().topRight().u(ticks), textureLayer.uv().topRight().v(ticks)).method_1344();
            bufferbuilder.method_22918(lastMatrix, corner10.x, corner10.y, corner10.z).method_22913(textureLayer.uv().bottomRight().u(ticks), textureLayer.uv().bottomRight().v(ticks)).method_1344();
            bufferbuilder.method_22918(lastMatrix, corner11.x, corner11.y, corner11.z).method_22913(textureLayer.uv().bottomLeft().u(ticks), textureLayer.uv().bottomLeft().v(ticks)).method_1344();
            bufferbuilder.method_22918(lastMatrix, corner01.x, corner01.y, corner01.z).method_22913(textureLayer.uv().topLeft().u(ticks), textureLayer.uv().topLeft().v(ticks)).method_1344();
            class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
            RenderSystem.defaultBlendFunc();
        }

        public final void render(class_287 bufferbuilder, Matrix4f lastMatrix, SphericalCoords sphericalCoords, Color.FloatRGBA rgba, long ticks, float mulSize, float addRotation) {
            for (TextureLayer textureLayer : this.textureLayers) {
                this.renderTextureLayer(textureLayer, bufferbuilder, lastMatrix, sphericalCoords, rgba, ticks, mulSize, addRotation);
            }
        }
    }

    public static class MeteorShower
    extends MeteorEffect {
        protected static final int TICKS = 1000;
        protected static final float MAX_SIZE = 1.0f;
        protected static final int DURATION = 20;
        public static final Codec<MeteorShower> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MeteorType.CODEC.listOf().fieldOf("meteor_types").forGetter(MeteorEffect::getMeteorTypes), (App)Codec.DOUBLE.fieldOf("probability").forGetter(MeteorEffect::getRarity)).apply((Applicative)instance, MeteorShower::new));

        public MeteorShower(List<MeteorType> meteorTypes, double rarity) {
            super(meteorTypes, rarity);
        }

        public MeteorShower() {
            this(new ArrayList<MeteorType>(), 0.0);
        }

        @Override
        public double getRarity(ViewCenter viewCenter) {
            if (!viewCenter.overrideMeteorEffects()) {
                return this.rarity;
            }
            return viewCenter.overrideMeteorShowerRarity();
        }

        @Override
        public final void render(ViewCenter viewCenter, class_638 level, class_4184 camera, float partialTicks, class_4587 stack, class_287 bufferbuilder) {
            if (!this.canRender(viewCenter)) {
                return;
            }
            long dailySeed = viewCenter.ticks() / (viewCenter.getRotationPeriod() == 0L ? 24000L : viewCenter.getRotationPeriod());
            if (this.shouldAppear(viewCenter, dailySeed)) {
                double position = viewCenter.ticks() % 20L;
                long meteorRandomizer = viewCenter.ticks() / 20L;
                Random random = new Random(meteorRandomizer);
                float xRotation = (float)((double)random.nextInt(0, 45) + Math.PI * class_3532.method_16436((double)partialTicks, (double)(position - 1.0), (double)position));
                float yRotation = random.nextInt(0, 360);
                float zRotation = random.nextInt(-70, 70);
                MeteorType meteorType = this.getRandomMeteorType(dailySeed);
                float rotation = (float)(Math.PI * position / 4.0);
                float size = (float)Math.sin(Math.PI * position / 20.0);
                this.render(viewCenter, level, camera, partialTicks, stack, bufferbuilder, xRotation, yRotation, zRotation, meteorType, size, rotation);
            }
        }
    }

    public static class ShootingStar
    extends MeteorEffect {
        protected static final int TICKS = 1000;
        protected static final float MAX_SIZE = 1.0f;
        protected static final int DURATION = 20;
        public static final Codec<ShootingStar> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MeteorType.CODEC.listOf().fieldOf("meteor_types").forGetter(MeteorEffect::getMeteorTypes), (App)Codec.DOUBLE.fieldOf("probability").forGetter(MeteorEffect::getRarity)).apply((Applicative)instance, ShootingStar::new));

        public ShootingStar(List<MeteorType> meteorTypes, double rarity) {
            super(meteorTypes, rarity);
        }

        public ShootingStar() {
            this(new ArrayList<MeteorType>(), 0.0);
        }

        @Override
        public double getRarity(ViewCenter viewCenter) {
            if (!viewCenter.overrideMeteorEffects()) {
                return this.rarity;
            }
            return viewCenter.overrideShootingStarRarity();
        }

        @Override
        public final void render(ViewCenter viewCenter, class_638 level, class_4184 camera, float partialTicks, class_4587 stack, class_287 bufferbuilder) {
            if (!this.canRender(viewCenter)) {
                return;
            }
            long tickSeed = viewCenter.ticks() / 1000L;
            int specificTime = (int)(viewCenter.ticks() % 1000L);
            Random randomizer = new Random(tickSeed);
            int randomStart = randomizer.nextInt(0, 980);
            if (this.shouldAppear(viewCenter, tickSeed) && specificTime >= randomStart && specificTime < randomStart + 20) {
                double position = viewCenter.ticks() % 20L;
                long shootingStarRandomizer = viewCenter.ticks() / 20L;
                Random random = new Random(shootingStarRandomizer);
                float xRotation = (float)((double)random.nextInt(0, 45) + Math.PI * class_3532.method_16436((double)partialTicks, (double)(position - 1.0), (double)position));
                float yRotation = random.nextInt(0, 360);
                float zRotation = random.nextInt(-70, 70);
                MeteorType meteorType = this.getRandomMeteorType(tickSeed);
                float rotation = (float)(Math.PI * position / 4.0);
                float size = (float)Math.sin(Math.PI * position / 20.0);
                this.render(viewCenter, level, camera, partialTicks, stack, bufferbuilder, xRotation, yRotation, zRotation, meteorType, size, rotation);
            }
        }
    }
}

