/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.povstalec.stellarview.api.common.space_objects.distinct.Luna;
import net.povstalec.stellarview.api.common.space_objects.distinct.Sol;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.BlackHole;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Moon;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Nebula;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Planet;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Star;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.SpaceObjectRenderers;
import net.povstalec.stellarview.client.render.level.StellarViewEndEffects;
import net.povstalec.stellarview.client.render.level.StellarViewNetherEffects;
import net.povstalec.stellarview.client.render.level.StellarViewOverworldEffects;
import net.povstalec.stellarview.client.render.space_objects.distinct.LunaRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.BlackHoleRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.ConstellationRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.MoonRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.NebulaRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.PlanetRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.StarFieldRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.StarRenderer;
import net.povstalec.stellarview.client.resourcepack.ResourcepackReloadListener;
import net.povstalec.stellarview.client.screens.config.ConfigScreen;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import net.povstalec.stellarview.common.util.KeyBindings;
import net.povstalec.stellarview.compatibility.aether.AetherCompatibility;
import net.povstalec.stellarview.compatibility.twilightforest.TwilightForestCompatibility;
import org.slf4j.Logger;

@Mod(value="stellarview")
public class StellarView {
    public static final String MODID = "stellarview";
    public static final String ENHANCED_CELESTIALS_MODID = "enhancedcelestials";
    public static final String LUNAR_MODID = "lunar";
    public static final String TWILIGHT_FOREST_MODID = "twilightforest";
    public static final String AETHER_MODID = "aether";
    private static Optional<Boolean> isEnhancedCelestialsLoaded = Optional.empty();
    private static Optional<Boolean> isLunarLoaded = Optional.empty();
    private static Optional<Boolean> isTwilightForestLoaded = Optional.empty();
    private static Optional<Boolean> isAetherLoaded = Optional.empty();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static StellarViewOverworldEffects overworld;
    public static StellarViewNetherEffects nether;
    public static StellarViewEndEffects end;

    public StellarView() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)StellarViewConfig.CLIENT_CONFIG, "stellarview-client.toml");
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((BiFunction)new BiFunction<Minecraft, Screen, Screen>(){

            @Override
            public Screen apply(Minecraft mc, Screen screen) {
                return new ConfigScreen(screen);
            }
        }));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isEnhancedCelestialsLoaded() {
        if (isEnhancedCelestialsLoaded.isEmpty()) {
            isEnhancedCelestialsLoaded = Optional.of(ModList.get().isLoaded(ENHANCED_CELESTIALS_MODID));
        }
        return isEnhancedCelestialsLoaded.get();
    }

    public static boolean isLunarLoaded() {
        if (isLunarLoaded.isEmpty()) {
            isLunarLoaded = Optional.of(ModList.get().isLoaded(LUNAR_MODID));
        }
        return isLunarLoaded.get();
    }

    public static boolean isTwilightForestLoaded() {
        if (isTwilightForestLoaded.isEmpty()) {
            isTwilightForestLoaded = Optional.of(ModList.get().isLoaded(TWILIGHT_FOREST_MODID));
        }
        return isTwilightForestLoaded.get();
    }

    public static boolean isAetherLoaded() {
        if (isAetherLoaded.isEmpty()) {
            isAetherLoaded = Optional.of(ModList.get().isLoaded(AETHER_MODID));
        }
        return isAetherLoaded.get();
    }

    @Mod.EventBusSubscriber(modid="stellarview", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                SpaceObjectRenderers.register(Planet.class, PlanetRenderer::new);
                SpaceObjectRenderers.register(Moon.class, MoonRenderer::new);
                SpaceObjectRenderers.register(Luna.class, LunaRenderer::new);
                SpaceObjectRenderers.register(Star.class, StarRenderer::new);
                SpaceObjectRenderers.register(Sol.class, StarRenderer::new);
                SpaceObjectRenderers.register(BlackHole.class, BlackHoleRenderer::new);
                SpaceObjectRenderers.register(Nebula.class, NebulaRenderer::new);
                SpaceObjectRenderers.register(StarField.class, StarFieldRenderer::new);
                SpaceObjectRenderers.register(Constellation.class, ConstellationRenderer::new);
            });
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
            overworld = new StellarViewOverworldEffects();
            nether = new StellarViewNetherEffects();
            end = new StellarViewEndEffects();
            event.register(StellarViewOverworldEffects.OVERWORLD_EFFECTS, (DimensionSpecialEffects)overworld);
            event.register(StellarViewNetherEffects.NETHER_EFFECTS, (DimensionSpecialEffects)nether);
            event.register(StellarViewEndEffects.END_EFFECTS, (DimensionSpecialEffects)end);
            if (StellarView.isTwilightForestLoaded()) {
                TwilightForestCompatibility.registerTwilightForestEffects(event);
            }
            if (StellarView.isAetherLoaded()) {
                AetherCompatibility.registerAetherEffects(event);
            }
        }

        @SubscribeEvent
        public static void registerClientReloadListener(RegisterClientReloadListenersEvent event) {
            ResourcepackReloadListener.ReloadListener.registerReloadListener(event);
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeyBindings.OPEN_CONFIG_KEY);
        }
    }
}

