/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import net.povstalec.stellarview.common.util.TextureLayer;

public abstract class TexturedObject
extends SpaceObject {
    public static final String TEXTURE_LAYERS = "texture_layers";
    public static final String FADE_OUT_HANDLER = "fade_out_handler";
    protected ArrayList<TextureLayer> textureLayers;
    protected FadeOutHandler fadeOutHandler;

    public TexturedObject() {
        this.textureLayers = new ArrayList();
    }

    public TexturedObject(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, List<TextureLayer> textureLayers, FadeOutHandler fadeOutHandler) {
        super(parent, coords, axisRotation);
        this.textureLayers = new ArrayList<TextureLayer>(textureLayers);
        this.fadeOutHandler = fadeOutHandler;
    }

    public ArrayList<TextureLayer> getTextureLayers() {
        return this.textureLayers;
    }

    public FadeOutHandler getFadeOutHandler() {
        return this.fadeOutHandler;
    }

    public double fadeOut(double distance) {
        double fadeOutEnd = this.getFadeOutHandler().getFadeOutEndDistance().toKm();
        if (distance > fadeOutEnd) {
            return 0.0;
        }
        double fadeOutStart = this.getFadeOutHandler().getFadeOutStartDistance().toKm();
        if (distance < fadeOutStart) {
            return 1.0;
        }
        return (distance - fadeOutStart) / (fadeOutEnd - fadeOutStart);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        CompoundTag textureLayerTag = new CompoundTag();
        int i = 0;
        for (TextureLayer textureLayer : this.textureLayers) {
            textureLayerTag.m_128365_(String.valueOf(i), (Tag)textureLayer.serializeNBT());
            ++i;
        }
        tag.m_128365_(TEXTURE_LAYERS, (Tag)textureLayerTag);
        tag.m_128365_(FADE_OUT_HANDLER, (Tag)this.fadeOutHandler.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        CompoundTag textureLayerTag = tag.m_128469_(TEXTURE_LAYERS);
        for (int i = 0; i < textureLayerTag.m_128440_(); ++i) {
            TextureLayer textureLayer = new TextureLayer();
            textureLayer.deserializeNBT(textureLayerTag.m_128469_(String.valueOf(i)));
            this.textureLayers.add(textureLayer);
        }
        this.fadeOutHandler = new FadeOutHandler();
        this.fadeOutHandler.deserializeNBT(tag.m_128469_(FADE_OUT_HANDLER));
    }

    public static class FadeOutHandler
    implements INBTSerializable<CompoundTag> {
        public static final String FADE_OUT_START_DISTANCE = "fade_out_start_distance";
        public static final String FADE_OUT_END_DISTANCE = "fade_out_end_distance";
        public static final String MAX_CHILD_RENDER_DISTANCE = "max_child_render_distance";
        public static final FadeOutHandler DEFAULT_PLANET_HANDLER = new FadeOutHandler(new SpaceCoords.SpaceDistance(7.0E10), new SpaceCoords.SpaceDistance(1.0E11), new SpaceCoords.SpaceDistance(1.0E11));
        public static final FadeOutHandler DEFAULT_STAR_HANDLER = new FadeOutHandler(new SpaceCoords.SpaceDistance(5000000L), new SpaceCoords.SpaceDistance(10000000L), new SpaceCoords.SpaceDistance(1.0E11));
        public static final FadeOutHandler DEFAULT_NEBULA_HANDLER = new FadeOutHandler(new SpaceCoords.SpaceDistance(1000000L), new SpaceCoords.SpaceDistance(2000000L), new SpaceCoords.SpaceDistance(5000000L));
        private SpaceCoords.SpaceDistance fadeOutStartDistance;
        private SpaceCoords.SpaceDistance fadeOutEndDistance;
        private SpaceCoords.SpaceDistance maxChildRenderDistance;
        public static final Codec<FadeOutHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceCoords.SpaceDistance.CODEC.fieldOf(FADE_OUT_START_DISTANCE).forGetter(FadeOutHandler::getFadeOutStartDistance), (App)SpaceCoords.SpaceDistance.CODEC.fieldOf(FADE_OUT_END_DISTANCE).forGetter(FadeOutHandler::getFadeOutEndDistance), (App)SpaceCoords.SpaceDistance.CODEC.fieldOf(MAX_CHILD_RENDER_DISTANCE).forGetter(FadeOutHandler::getMaxChildRenderDistance)).apply((Applicative)instance, FadeOutHandler::new));

        public FadeOutHandler() {
        }

        public FadeOutHandler(SpaceCoords.SpaceDistance fadeOutStartDistance, SpaceCoords.SpaceDistance fadeOutEndDistance, SpaceCoords.SpaceDistance maxChildRenderDistance) {
            this.fadeOutStartDistance = fadeOutStartDistance;
            this.fadeOutEndDistance = fadeOutEndDistance;
            this.maxChildRenderDistance = maxChildRenderDistance;
        }

        public SpaceCoords.SpaceDistance getFadeOutStartDistance() {
            return this.fadeOutStartDistance;
        }

        public SpaceCoords.SpaceDistance getFadeOutEndDistance() {
            return this.fadeOutEndDistance;
        }

        public SpaceCoords.SpaceDistance getMaxChildRenderDistance() {
            return this.maxChildRenderDistance;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_(FADE_OUT_START_DISTANCE, (Tag)this.fadeOutStartDistance.serializeNBT());
            tag.m_128365_(FADE_OUT_END_DISTANCE, (Tag)this.fadeOutEndDistance.serializeNBT());
            tag.m_128365_(MAX_CHILD_RENDER_DISTANCE, (Tag)this.maxChildRenderDistance.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.fadeOutStartDistance = new SpaceCoords.SpaceDistance();
            this.fadeOutStartDistance.deserializeNBT(tag.m_128469_(FADE_OUT_START_DISTANCE));
            this.fadeOutEndDistance = new SpaceCoords.SpaceDistance();
            this.fadeOutEndDistance.deserializeNBT(tag.m_128469_(FADE_OUT_END_DISTANCE));
            this.maxChildRenderDistance = new SpaceCoords.SpaceDistance();
            this.maxChildRenderDistance.deserializeNBT(tag.m_128469_(MAX_CHILD_RENDER_DISTANCE));
        }
    }
}

