/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.common.SpaceRegion;
import net.povstalec.stellarview.api.common.space_objects.distinct.Sol;
import net.povstalec.stellarview.client.render.SpaceRegionRenderer;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Mat3f;
import net.povstalec.stellarview.common.util.SpaceCoords;

public final class SpaceRenderer {
    private static Minecraft minecraft = Minecraft.m_91087_();
    private static final Vector3f NULL_VECTOR = new Vector3f();
    private static final int STAR_LIMIT = 100000;
    private static final int DUST_CLOUD_LIMIT = 50000;
    private static final HashMap<SpaceRegion.RegionPos, SpaceRegionRenderer> SPACE_REGIONS = new HashMap();
    public static final Mat3f IDENTITY_MATRIX;
    public static Mat3f lensingMatrix;
    public static Mat3f lensingMatrixInv;
    public static float lensingIntensity;
    @Nullable
    private static Sol sol;
    @Nullable
    private static SpaceCoords solCoords;
    @Nullable
    private static AxisRotation solAxisRotation;
    private static int starsPerTick;
    private static int dustCloudsPerTick;

    public static void updateSpaceObjects() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        SpaceRenderer.updateSol();
        SpaceRenderer.resetStarFields();
    }

    public static boolean loadNewStars() {
        return starsPerTick < 100000;
    }

    public static void loadedStars(int starCount) {
        starsPerTick += starCount;
    }

    public static boolean loadNewDustClouds() {
        return dustCloudsPerTick < 50000;
    }

    public static void loadedDustClouds(int dustCloudCount) {
        dustCloudsPerTick += dustCloudCount;
    }

    public static void clear() {
        sol = null;
        solCoords = null;
        solAxisRotation = null;
        SPACE_REGIONS.clear();
    }

    public static void addSpaceRegion(SpaceRegionRenderer spaceRegion) {
        SPACE_REGIONS.put(spaceRegion.getRegionPos(), spaceRegion);
    }

    public static void removeSpaceRegion(SpaceRegion.RegionPos regionPos) {
        SPACE_REGIONS.remove(regionPos);
    }

    public static void addSpaceObjectRenderer(SpaceObjectRenderer<?> spaceObjectRenderer) {
        SpaceRegionRenderer region = SpaceRenderer.getOrCreateRegion(spaceObjectRenderer.spaceCoords());
        region.addChild(spaceObjectRenderer);
    }

    public static void setupSynodicOrbits() {
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            spaceRegionEntry.getValue().setupSynodicOrbits();
        }
    }

    public static void resetStarFields() {
        starsPerTick = 0;
        dustCloudsPerTick = 0;
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            spaceRegionEntry.getValue().resetStarFields();
            spaceRegionEntry.getValue().resetConstellations();
        }
    }

    public static void render(ViewCenter viewCenter, SpaceObjectRenderer masterParent, ClientLevel level, Camera camera, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, BufferBuilder bufferbuilder) {
        starsPerTick = 0;
        dustCloudsPerTick = 0;
        SpaceRenderer.setBestLensing();
        SpaceRegion.RegionPos pos = new SpaceRegion.RegionPos(viewCenter.getCoords());
        minecraft.m_91307_().m_6180_("dustClouds");
        if (viewCenter.dustCloudBrightness() > 0.0f) {
            for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
                if (!spaceRegionEntry.getKey().isInRange(pos, SpaceRenderer.getRange())) continue;
                spaceRegionEntry.getValue().renderDustClouds(viewCenter, level, camera, partialTicks, stack, projectionMatrix, setupFog, viewCenter.dustCloudBrightness());
            }
        }
        minecraft.m_91307_().m_7238_();
        SpaceRegionRenderer centerRegion = null;
        minecraft.m_91307_().m_6180_("spaceObjects");
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            if (!spaceRegionEntry.getKey().equals(pos)) {
                if (!spaceRegionEntry.getKey().isInRange(pos, SpaceRenderer.getRange())) continue;
                spaceRegionEntry.getValue().render(viewCenter, masterParent, level, camera, partialTicks, stack, projectionMatrix, isFoggy, setupFog, bufferbuilder);
                continue;
            }
            centerRegion = spaceRegionEntry.getValue();
        }
        if (centerRegion != null) {
            centerRegion.render(viewCenter, masterParent, level, camera, partialTicks, stack, projectionMatrix, isFoggy, setupFog, bufferbuilder);
        }
        masterParent.render(viewCenter, level, partialTicks, stack, camera, projectionMatrix, isFoggy, setupFog, bufferbuilder, NULL_VECTOR, new AxisRotation());
        minecraft.m_91307_().m_7238_();
    }

    private static void setBestLensing() {
        lensingMatrix = IDENTITY_MATRIX;
        lensingMatrixInv = IDENTITY_MATRIX;
        lensingIntensity = 0.0f;
        for (Map.Entry<SpaceRegion.RegionPos, SpaceRegionRenderer> spaceRegionEntry : SPACE_REGIONS.entrySet()) {
            spaceRegionEntry.getValue().setBestLensing();
        }
    }

    public static void addSol(Sol solStar) {
        if (sol != null) {
            StellarView.LOGGER.error("Could not set Sol as a distinct Space Object because it has already been set");
            return;
        }
        StellarView.LOGGER.debug("Setting Sol as a distinct Space Object");
        sol = solStar;
        solCoords = solStar.getCoords().copy();
        solAxisRotation = solStar.getAxisRotation().copy();
        SpaceRenderer.updateSol();
    }

    public static void updateSol() {
        if (sol == null) {
            return;
        }
        if (OverworldConfig.config_priority.get()) {
            SpaceCoords coords = solCoords.copy().add((long)OverworldConfig.sol_x_offset.get() * 1000L, (long)OverworldConfig.sol_y_offset.get() * 1000L, (long)OverworldConfig.sol_z_offset.get() * 1000L);
            AxisRotation axisRotation = solAxisRotation.copy().add(new AxisRotation(OverworldConfig.sol_x_rotation.get(), OverworldConfig.sol_y_rotation.get(), OverworldConfig.sol_z_rotation.get()));
            sol.setPosAndRotation(coords, axisRotation);
        } else {
            sol.setPosAndRotation(solCoords.copy(), solAxisRotation.copy());
        }
    }

    public static int getRange() {
        return GeneralConfig.space_region_render_distance.get();
    }

    @Nullable
    public static SpaceRegionRenderer getRegion(SpaceRegion.RegionPos pos) {
        if (SPACE_REGIONS.containsKey(pos)) {
            return SPACE_REGIONS.get(pos);
        }
        return null;
    }

    @Nullable
    public static SpaceRegionRenderer getRegion(SpaceCoords coords) {
        return SpaceRenderer.getRegion(new SpaceRegion.RegionPos(coords));
    }

    public static SpaceRegionRenderer getOrCreateRegion(SpaceRegion.RegionPos pos) {
        return SPACE_REGIONS.computeIfAbsent(pos, position -> new SpaceRegionRenderer(new SpaceRegion(pos)));
    }

    public static SpaceRegionRenderer getOrCreateRegion(SpaceCoords coords) {
        return SpaceRenderer.getOrCreateRegion(new SpaceRegion.RegionPos(coords));
    }

    static {
        lensingMatrix = IDENTITY_MATRIX = new Mat3f();
        lensingMatrixInv = IDENTITY_MATRIX;
        lensingIntensity = 0.0f;
        sol = null;
        solCoords = null;
        solAxisRotation = null;
        starsPerTick = 0;
        dustCloudsPerTick = 0;
    }
}

