/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.api.common.space_objects.GravityLense;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.render.space_objects.StarLikeRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.Mat3f;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.TextureLayer;

public abstract class GravityLenseRenderer<T extends GravityLense>
extends StarLikeRenderer<T> {
    protected SphericalCoords sphericalCoords = new SphericalCoords(0.0, 0.0, 0.0);

    public GravityLenseRenderer(T gravityLense) {
        super(gravityLense);
    }

    public float lensingIntensity() {
        return ((GravityLense)this.renderedObject).getLensingIntensity();
    }

    public double maxLensingDistance() {
        return ((GravityLense)this.renderedObject).getMaxLensingDistance();
    }

    public static double cosFromSin(float angle) {
        return Math.sin((double)angle + 1.5707963267948966);
    }

    private Quaternion rotateY(float angle, Quaternion dest) {
        double sin = Math.sin(angle * 0.5f);
        double cos = GravityLenseRenderer.cosFromSin(angle * 0.5f);
        dest.m_80143_((float)((double)dest.m_80140_() * cos - (double)dest.m_80153_() * sin), (float)((double)dest.m_80156_() * sin + (double)dest.m_80150_() * cos), (float)((double)dest.m_80140_() * sin + (double)dest.m_80153_() * cos), (float)((double)dest.m_80156_() * cos - (double)dest.m_80150_() * sin));
        return dest;
    }

    private Quaternion rotateX(float angle, Quaternion dest) {
        double sin = Math.sin(angle * 0.5f);
        double cos = GravityLenseRenderer.cosFromSin(angle * 0.5f);
        dest.m_80143_((float)((double)dest.m_80156_() * sin + (double)dest.m_80140_() * cos), (float)((double)dest.m_80150_() * cos + (double)dest.m_80153_() * sin), (float)((double)dest.m_80153_() * cos - (double)dest.m_80150_() * sin), (float)((double)dest.m_80156_() * cos - (double)dest.m_80140_() * sin));
        return dest;
    }

    private Quaternion invert(Quaternion dest) {
        float invNorm = 1.0f / Math.fma(dest.m_80140_(), dest.m_80140_(), Math.fma(dest.m_80150_(), dest.m_80150_(), Math.fma(dest.m_80153_(), dest.m_80153_(), dest.m_80156_() * dest.m_80156_())));
        dest.m_80143_(-dest.m_80140_() * invNorm, -dest.m_80150_() * invNorm, -dest.m_80153_() * invNorm, dest.m_80156_() * invNorm);
        return dest;
    }

    public void setupLensing() {
        float intensity = (float)((GravityLense)this.renderedObject).getLensingIntensity(this.lastDistance);
        if (intensity < SpaceRenderer.lensingIntensity) {
            return;
        }
        Quaternion lensingQuat = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        this.rotateY((float)this.sphericalCoords.theta, lensingQuat);
        Quaternion temp = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        lensingQuat.m_80148_(this.rotateX((float)this.sphericalCoords.phi, temp));
        Mat3f lensingMatrixInv = new Mat3f().rotate(lensingQuat);
        Mat3f lensingMatrix = new Mat3f().rotate(this.invert(lensingQuat));
        SpaceRenderer.lensingIntensity = intensity;
        SpaceRenderer.lensingMatrixInv = lensingMatrixInv;
        SpaceRenderer.lensingMatrix = lensingMatrix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderTextureLayer(TextureLayer textureLayer, ViewCenter viewCenter, ClientLevel level, Camera camera, BufferBuilder bufferbuilder, Matrix4f lastMatrix, SphericalCoords sphericalCoords, double fade, long ticks, double distance, float partialTicks) {
        double lyDistance = distance / 9.4607304725812E12;
        Color.FloatRGBA starRGBA = ((GravityLense)this.renderedObject).starRGBA(lyDistance);
        if (starRGBA.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
            return;
        }
        GravityLense cfr_ignored_0 = (GravityLense)this.renderedObject;
        float size = (float)textureLayer.mulSize(GravityLense.distanceSize(distance));
        if ((double)size < textureLayer.minSize()) {
            if (!textureLayer.clampAtMinSize()) return;
            size = (float)textureLayer.minSize();
            size = ((GravityLense)this.renderedObject).starSize(size, lyDistance);
        } else if ((double)size > textureLayer.maxSize()) {
            if (!textureLayer.clampAtMaxSize()) return;
            size = (float)textureLayer.maxSize();
        }
        GravityLenseRenderer.renderOnSphere(textureLayer.rgba(), starRGBA, textureLayer.texture(), textureLayer.uv(), level, camera, bufferbuilder, lastMatrix, sphericalCoords, ticks, distance, partialTicks, LightEffects.dayBrightness(viewCenter, size, ticks, level, camera, partialTicks) * (float)fade, size, (float)textureLayer.rotation(), textureLayer.shoulBlend());
    }

    @Override
    public void render(ViewCenter viewCenter, ClientLevel level, float partialTicks, PoseStack stack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, BufferBuilder bufferbuilder, Vector3f parentVector, AxisRotation parentRotation) {
        Vector3f positionVector = this.getPosition(viewCenter, parentRotation, viewCenter.ticks(), partialTicks);
        positionVector.m_122253_(parentVector);
        SpaceCoords coords = ((GravityLense)this.renderedObject).getCoords().add(positionVector);
        this.sphericalCoords = coords.skyPosition(level, viewCenter, partialTicks, false);
        SphericalCoords sphericalCoords = coords.skyPosition(level, viewCenter, partialTicks, true);
        this.lastDistance = sphericalCoords.r;
        sphericalCoords.r = 100.0;
        if (((GravityLense)this.renderedObject).getFadeOutHandler().getMaxChildRenderDistance().toKm() > this.lastDistance) {
            for (SpaceObjectRenderer child : this.children) {
                if (!(child.lastDistance >= this.lastDistance)) continue;
                child.render(viewCenter, level, partialTicks, stack, camera, projectionMatrix, isFoggy, setupFog, bufferbuilder, positionVector, this.axisRotation());
            }
        }
        if (!viewCenter.objectEquals(this) && ((GravityLense)this.renderedObject).getFadeOutHandler().getFadeOutEndDistance().toKm() > this.lastDistance) {
            this.renderTextureLayers(viewCenter, level, camera, bufferbuilder, stack.m_85850_().m_85861_(), sphericalCoords, viewCenter.ticks(), this.lastDistance, partialTicks);
        }
        if (((GravityLense)this.renderedObject).getFadeOutHandler().getMaxChildRenderDistance().toKm() > this.lastDistance) {
            for (SpaceObjectRenderer child : this.children) {
                if (!(child.lastDistance < this.lastDistance)) continue;
                child.render(viewCenter, level, partialTicks, stack, camera, projectionMatrix, isFoggy, setupFog, bufferbuilder, positionVector, this.axisRotation());
            }
        }
    }
}

