/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects;

import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.stellarview.api.common.space_objects.OrbitingObject;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.render.space_objects.TexturedObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.AxisRotation;

public abstract class OrbitingObjectRenderer<T extends OrbitingObject>
extends TexturedObjectRenderer<T> {
    public OrbitingObjectRenderer(T orbitingObject) {
        super(orbitingObject);
    }

    @Nullable
    public OrbitingObject.OrbitInfo orbitInfo() {
        return ((OrbitingObject)this.renderedObject).orbitInfo();
    }

    @Override
    public void setupSpaceObject(ResourceLocation id, @Nullable SpaceObjectRenderer<?> parent) {
        super.setupSpaceObject(id, parent);
        if (parent instanceof OrbitingObjectRenderer) {
            OrbitingObjectRenderer orbitingObjectRenderer = (OrbitingObjectRenderer)parent;
            if (((OrbitingObject)orbitingObjectRenderer.renderedObject).orbitInfo() != null) {
                this.setupSynodicOrbit(((OrbitingObject)orbitingObjectRenderer.renderedObject).orbitInfo().orbitalPeriod());
            }
        }
    }

    public void setupSynodicOrbit(@Nullable OrbitingObject.OrbitalPeriod parentOrbitalPeriod) {
        ((OrbitingObject)this.renderedObject).setupSynodicOrbit(parentOrbitalPeriod);
    }

    @Override
    public Vector3f getPosition(ViewCenter viewCenter, AxisRotation axisRotation, long ticks, float partialTicks) {
        return axisRotation.quaterniond().transform(this.getPosition(viewCenter, ticks, partialTicks));
    }

    @Override
    public Vector3f getPosition(ViewCenter viewCenter, long ticks, float partialTicks) {
        if (this.orbitInfo() != null) {
            if (!viewCenter.objectEquals(this) && this.orbitInfo().orbitClampNumber() > 0.0f && this.parent != null) {
                return this.orbitInfo().getOrbitVector(ticks, partialTicks, this.parent.lastDistance);
            }
            return this.orbitInfo().getOrbitVector(ticks, partialTicks);
        }
        return super.getPosition(viewCenter, ticks, partialTicks);
    }
}

