/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects.resourcepack;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Moon;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.PlanetRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.TextureLayer;

public class MoonRenderer<T extends Moon>
extends PlanetRenderer<T> {
    public MoonRenderer(T moon) {
        super(moon);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderTextureLayer(TextureLayer textureLayer, ViewCenter viewCenter, ClientLevel level, Camera camera, BufferBuilder bufferbuilder, Matrix4f lastMatrix, SphericalCoords sphericalCoords, double fade, long ticks, double distance, float partialTicks) {
        if (!StellarView.isEnhancedCelestialsLoaded() && !StellarView.isLunarLoaded()) {
            super.renderTextureLayer(textureLayer, viewCenter, level, camera, bufferbuilder, lastMatrix, sphericalCoords, fade, ticks, distance, partialTicks);
            return;
        }
        Color.FloatRGBA moonRGBA = ((Moon)this.renderedObject).moonRGBA(level, partialTicks);
        if (moonRGBA.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
            return;
        }
        Moon cfr_ignored_0 = (Moon)this.renderedObject;
        float size = (float)textureLayer.mulSize(Moon.distanceSize(distance));
        if ((double)size < textureLayer.minSize()) {
            if (!textureLayer.clampAtMinSize()) return;
            size = (float)textureLayer.minSize();
        } else if ((double)size > textureLayer.maxSize()) {
            if (!textureLayer.clampAtMaxSize()) return;
            size = (float)textureLayer.maxSize();
        }
        MoonRenderer.renderOnSphere(textureLayer.rgba(), moonRGBA, textureLayer.texture(), textureLayer.uv(), level, camera, bufferbuilder, lastMatrix, sphericalCoords, ticks, distance, partialTicks, LightEffects.dayBrightness(viewCenter, size *= ((Moon)this.renderedObject).sizeMultiplier(level), ticks, level, camera, partialTicks) * (float)fade, size, (float)textureLayer.rotation(), textureLayer.shoulBlend());
    }
}

