/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Mat3f {
    private static final NumberFormat FORMAT = new DecimalFormat("0.###E0");
    float m00 = 1.0f;
    float m01;
    float m02;
    float m10;
    float m11 = 1.0f;
    float m12;
    float m20;
    float m21;
    float m22 = 1.0f;

    public Mat3f scale(float x, float y, float z) {
        this.m00 *= x;
        this.m01 *= x;
        this.m02 *= x;
        this.m10 *= y;
        this.m11 *= y;
        this.m12 *= y;
        this.m20 *= z;
        this.m21 *= z;
        this.m22 *= z;
        return this;
    }

    public Mat3f rotate(Quaternion quat) {
        float m00 = this.m00;
        float m01 = this.m01;
        float m02 = this.m02;
        float m10 = this.m10;
        float m11 = this.m11;
        float m12 = this.m12;
        float m20 = this.m20;
        float m21 = this.m21;
        float m22 = this.m22;
        float w2 = quat.m_80156_() * quat.m_80156_();
        float x2 = quat.m_80140_() * quat.m_80140_();
        float y2 = quat.m_80150_() * quat.m_80150_();
        float z2 = quat.m_80153_() * quat.m_80153_();
        float zw = quat.m_80153_() * quat.m_80156_();
        float dzw = zw + zw;
        float xy = quat.m_80140_() * quat.m_80150_();
        float dxy = xy + xy;
        float xz = quat.m_80140_() * quat.m_80153_();
        float dxz = xz + xz;
        float yw = quat.m_80150_() * quat.m_80156_();
        float dyw = yw + yw;
        float yz = quat.m_80150_() * quat.m_80153_();
        float dyz = yz + yz;
        float xw = quat.m_80140_() * quat.m_80156_();
        float dxw = xw + xw;
        float rm00 = w2 + x2 - z2 - y2;
        float rm01 = dxy + dzw;
        float rm02 = dxz - dyw;
        float rm10 = -dzw + dxy;
        float rm11 = y2 - z2 + w2 - x2;
        float rm12 = dyz + dxw;
        float rm20 = dyw + dxz;
        float rm21 = dyz - dxw;
        float rm22 = z2 - y2 - x2 + w2;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m20 = m00 * rm20 + m10 * rm21 + m20 * rm22;
        this.m21 = m01 * rm20 + m11 * rm21 + m21 * rm22;
        this.m22 = m02 * rm20 + m12 * rm21 + m22 * rm22;
        return this;
    }

    public Matrix3f toMatrix3f() {
        float[] values = new float[]{this.m00, this.m01, this.m02, 0.0f, this.m10, this.m11, this.m12, 0.0f, this.m20, this.m21, this.m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return new Matrix3f(new Matrix4f(values));
    }

    public String toString() {
        return FORMAT.format(this.m00) + " " + FORMAT.format(this.m10) + " " + FORMAT.format(this.m20) + "\n" + FORMAT.format(this.m01) + " " + FORMAT.format(this.m11) + " " + FORMAT.format(this.m21) + "\n" + FORMAT.format(this.m02) + " " + FORMAT.format(this.m12) + " " + FORMAT.format(this.m22) + "\n";
    }
}

