/*
 * Decompiled with CFR 0.152.
 */
package pixellover.dyable.fluid;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import pixellover.dyable.init.DyableModBlocks;
import pixellover.dyable.init.DyableModFluidTypes;
import pixellover.dyable.init.DyableModFluids;
import pixellover.dyable.init.DyableModItems;

public abstract class WaterMagentaFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)DyableModFluidTypes.WATER_MAGENTA_TYPE.get(), () -> (Fluid)DyableModFluids.WATER_MAGENTA.get(), () -> (Fluid)DyableModFluids.FLOWING_WATER_MAGENTA.get()).explosionResistance(100.0f).bucket(() -> (Item)DyableModItems.WATER_MAGENTA_BUCKET.get()).block(() -> (LiquidBlock)DyableModBlocks.WATER_MAGENTA.get());

    private WaterMagentaFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    public static class Flowing
    extends WaterMagentaFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends WaterMagentaFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

