/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.yo_hooks.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yori3o.yo_hooks.item.HookItem;
import com.yori3o.yo_hooks.register.ModEntities;
import com.yori3o.yo_hooks.utils.PlayerWithHookData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HookEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Boolean> IN_BLOCK = SynchedEntityData.defineId(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.defineId(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> HOOK_RANGE = SynchedEntityData.defineId(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public PoseStack.Pose armPose;

    public HookEntity(EntityType<? extends HookEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public HookEntity(Level level, LivingEntity owner, int hookRange) {
        this((EntityType<? extends HookEntity>)((EntityType)ModEntities.HOOK_ENTITY.get()), level);
        this.setOwner((Entity)owner);
        this.setPos(owner.getX(), owner.getEyeY(), owner.getZ());
        this.setDeltaMovement(owner.getLookAngle().scale(2.0));
        this.setMaxRange(hookRange);
    }

    public void setArmPose(PoseStack.Pose pose) {
        this.armPose = pose;
    }

    @Nullable
    public PoseStack.Pose getArmPose() {
        return this.armPose;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(IN_BLOCK, (Object)false);
        builder.define(LENGTH, (Object)Float.valueOf(0.0f));
        builder.define(HOOK_RANGE, (Object)0);
    }

    public void tick() {
        super.tick();
        Player player = this.getPlayerOwner();
        if (player == null || !this.level().isClientSide && this.discardIfInvalid(player)) {
            this.discard();
            return;
        }
        if (this.isInBlock()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitResult.getType() != HitResult.Type.MISS) {
            this.onHit(hitResult);
        }
        this.checkInsideBlocks();
    }

    private boolean discardIfInvalid(Player player) {
        if (!player.isAlive() || player.isRemoved() || !(player.getMainHandItem().getItem() instanceof HookItem) && !(player.getOffhandItem().getItem() instanceof HookItem) || this.distanceToSqr((Entity)player) > (double)this.getMaxRange()) {
            this.discard();
            return true;
        }
        return false;
    }

    protected boolean canHitEntity(Entity entity) {
        return false;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.setDeltaMovement(Vec3.ZERO);
        this.setInBlock(true);
        this.setPos(result.getLocation());
        Player player = this.getPlayerOwner();
        if (player != null) {
            double dist = player.getEyePosition().subtract(result.getLocation()).length();
            this.setLength(Math.max((float)dist * 0.5f - 3.0f, 1.5f));
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putBoolean("in_block", this.isInBlock());
        tag.putFloat("length", this.getLength());
        tag.putInt("hook_range", this.getMaxRange());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setInBlock(tag.getBoolean("in_block"));
        this.setLength(tag.getFloat("length"));
        this.setMaxRange(tag.getInt("hook_range"));
    }

    private void setInBlock(boolean inBlock) {
        this.entityData.set(IN_BLOCK, (Object)inBlock);
    }

    private void setLength(float length) {
        this.entityData.set(LENGTH, (Object)Float.valueOf(length));
    }

    private void setMaxRange(int MAX_RANGE) {
        this.entityData.set(HOOK_RANGE, (Object)MAX_RANGE);
    }

    public boolean isInBlock() {
        return (Boolean)this.entityData.get(IN_BLOCK);
    }

    public float getLength() {
        return ((Float)this.entityData.get(LENGTH)).floatValue();
    }

    public int getMaxRange() {
        return (Integer)this.entityData.get(HOOK_RANGE);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason reason) {
        this.setHookForPlayer(null);
        super.remove(reason);
    }

    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        this.setHookForPlayer(this);
    }

    private void setHookForPlayer(@Nullable HookEntity hookEntity) {
        Player player = this.getPlayerOwner();
        if (player instanceof PlayerWithHookData) {
            PlayerWithHookData data = (PlayerWithHookData)player;
            data.setHook(hookEntity);
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Entity entity = this.getOwner();
        return entity instanceof Player ? (Player)entity : null;
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (this.getPlayerOwner() == null) {
            this.kill();
        }
    }
}

