/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.yo_hooks.item;

import com.yori3o.yo_hooks.config.ServerConfig;
import com.yori3o.yo_hooks.entity.HookEntity;
import com.yori3o.yo_hooks.utils.HooksAttributes;
import com.yori3o.yo_hooks.utils.PlayerWithHookData;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class HookItem
extends Item {
    private final int hookRange;
    private final Item itemForRepair;
    private static ServerConfig sc = new ServerConfig();
    private static final float decreaseSatiety = ((ServerConfig.Values)HookItem.sc.get()).decreaseSatiety;

    public HookItem(Item.Properties properties, int hookRange, Item itemForRepair) {
        super(properties);
        this.hookRange = hookRange;
        this.itemForRepair = itemForRepair;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        HookEntity hook = ((PlayerWithHookData)player).getHook();
        if (hook != null) {
            HookItem.discard(world, player, hook);
        } else {
            if (!world.isClientSide) {
                stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                player.getFoodData().addExhaustion(decreaseSatiety / 1.5f);
            }
            this.fire(world, player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private void fire(Level world, Player player) {
        if (!world.isClientSide) {
            world.addFreshEntity((Entity)new HookEntity(world, (LivingEntity)player, this.hookRange));
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
    }

    private static void discard(Level world, Player player, HookEntity hook) {
        if (!world.isClientSide) {
            hook.discard();
            ((PlayerWithHookData)player).setHook(null);
        }
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
    }

    public int getHookRange() {
        return this.hookRange;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.literal((String)(Component.translatable((String)"gui.yo_hooks.hooks.desc_1").getString().split("%")[0] + HooksAttributes.getHookRangeInBlocks(this.hookRange) + Component.translatable((String)"gui.yo_hooks.hooks.desc_1").getString().split("%")[1])));
    }

    public boolean isValidRepairItem(ItemStack itemStack, ItemStack itemStack2) {
        return itemStack2.is(this.itemForRepair);
    }
}

