/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.yo_hooks.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yori3o.yo_hooks.entity.HookEntity;
import com.yori3o.yo_hooks.item.HookItem;
import com.yori3o.yo_hooks.utils.HooksAttributes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HookRenderer
extends EntityRenderer<HookEntity> {
    private final ItemRenderer itemRenderer;

    public HookRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(HookEntity hookEntity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        @Nullable Player player = hookEntity.getPlayerOwner();
        if (player == null) {
            return;
        }
        poseStack.pushPose();
        Vec3 handPos = this.getHandPosition(player, partialTicks, this.entityRenderDispatcher);
        Vec3 hookPos = new Vec3(Mth.lerp((double)partialTicks, (double)hookEntity.xo, (double)hookEntity.getX()), Mth.lerp((double)partialTicks, (double)hookEntity.yo, (double)hookEntity.getY()) + (double)hookEntity.getEyeHeight(), Mth.lerp((double)partialTicks, (double)hookEntity.zo, (double)hookEntity.getZ()));
        Vec3 vectorCable = handPos.subtract(hookPos);
        float length = (float)(vectorCable.length() + 0.1);
        vectorCable = vectorCable.normalize();
        float pitch = (float)Math.acos(vectorCable.y);
        float yawAngle = (float)Math.atan2(vectorCable.z, vectorCable.x);
        poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - yawAngle) * 57.295776f));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch * 57.295776f));
        poseStack.pushPose();
        poseStack.mulPose(Axis.ZP.rotationDegrees(135.0f));
        poseStack.translate(-0.125f, 0.0f, 0.0f);
        ItemStack hookStack = HooksAttributes.hookStack(hookEntity.getMaxRange());
        BakedModel model = this.itemRenderer.getModel(hookStack, hookEntity.level(), null, 0);
        this.itemRenderer.render(hookStack, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        float x1 = 0.1f * Mth.cos((float)((float)Math.PI));
        float z1 = 0.1f * Mth.sin((float)((float)Math.PI));
        float x2 = 0.1f * Mth.cos((float)0.0f);
        float z2 = 0.1f * Mth.sin((float)0.0f);
        float x3 = 0.1f * Mth.cos((float)1.5707964f);
        float z3 = 0.1f * Mth.sin((float)1.5707964f);
        float x4 = 0.1f * Mth.cos((float)4.712389f);
        float z4 = 0.1f * Mth.sin((float)4.712389f);
        float ropeLength = length;
        float ropeAA = -1.0f;
        float ropeAB = length * 2.5f + ropeAA;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yo_hooks", (String)"textures/entity/hook_rope.png")));
        PoseStack.Pose entry = poseStack.last();
        this.vertex(vertexConsumer, entry, x1, ropeLength, z1, 0.4999f, ropeAB, packedLight);
        this.vertex(vertexConsumer, entry, x1, 0.0f, z1, 0.4999f, ropeAA, packedLight);
        this.vertex(vertexConsumer, entry, x2, 0.0f, z2, 0.0f, ropeAA, packedLight);
        this.vertex(vertexConsumer, entry, x2, ropeLength, z2, 0.0f, ropeAB, packedLight);
        this.vertex(vertexConsumer, entry, x3, ropeLength, z3, 1.0f, ropeAB, packedLight);
        this.vertex(vertexConsumer, entry, x3, 0.0f, z3, 1.0f, ropeAA, packedLight);
        this.vertex(vertexConsumer, entry, x4, 0.0f, z4, 0.4999f, ropeAA, packedLight);
        this.vertex(vertexConsumer, entry, x4, ropeLength, z4, 0.4999f, ropeAB, packedLight);
        poseStack.popPose();
        super.render((Entity)hookEntity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    private void vertex(VertexConsumer vertexConsumer, PoseStack.Pose matrix, float x, float y, float z, float u, float v, int packedLight) {
        vertexConsumer.addVertex(matrix.pose(), x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(matrix, 0.0f, 1.0f, 0.0f);
    }

    public Vec3 getHandPosition(Player player, float partialTicks, EntityRenderDispatcher dispatcher) {
        boolean isMainHand = player.getMainHandItem().getItem() instanceof HookItem;
        boolean isOffHand = player.getOffhandItem().getItem() instanceof HookItem;
        HumanoidArm hookArm = isMainHand ? player.getMainArm() : (isOffHand ? player.getMainArm().getOpposite() : player.getMainArm());
        int armSign = hookArm == HumanoidArm.RIGHT ? 1 : -1;
        float bodyYawRad = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double sinYaw = Mth.sin((float)bodyYawRad);
        double cosYaw = Mth.cos((float)bodyYawRad);
        double sideOffset = (double)armSign * 0.35;
        double forwardOffset = 0.4;
        if (!dispatcher.options.getCameraType().isFirstPerson() || player != Minecraft.getInstance().player) {
            float sneakOffset = player.isCrouching() ? -0.1875f : 0.0f;
            double x = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - cosYaw * sideOffset - sinYaw * forwardOffset;
            double z = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - sinYaw * sideOffset + cosYaw * forwardOffset;
            double y = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + (double)player.getEyeHeight() - 0.55 + (double)sneakOffset;
            return new Vec3(x, y, z);
        }
        double fovScale = 960.0 / (double)((Integer)dispatcher.options.fov().get()).intValue();
        Vec3 lookVector = new Vec3(dispatcher.camera.getLookVector());
        Vec3 rightVector = lookVector.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 upVector = rightVector.cross(lookVector).normalize();
        Vec3 projectedVec = rightVector.scale((double)armSign * 0.055).add(upVector.scale(-0.025)).scale(fovScale);
        float sinSwing = Mth.sin((float)(Mth.sqrt((float)player.getAttackAnim(partialTicks)) * (float)Math.PI));
        projectedVec = projectedVec.yRot(sinSwing * 0.5f);
        projectedVec = projectedVec.xRot(-sinSwing * 0.7f);
        return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) + projectedVec.x, Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + projectedVec.y + (double)player.getEyeHeight(), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) + projectedVec.z);
    }

    public ResourceLocation getTextureLocation(HookEntity hookEntity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

