/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingAttackEvent;
import java.util.EnumSet;
import java.util.Optional;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8103;

public class Guard {
    public static final class_2960 ADVANCEMENT_GUARD = class_2960.method_60655((String)"slashblade", (String)"abilities/guard");
    public static final class_2960 ADVANCEMENT_GUARD_JUST = class_2960.method_60655((String)"slashblade", (String)"abilities/guard_just");
    static final EnumSet<InputCommand> move = EnumSet.of(InputCommand.FORWARD, InputCommand.BACK, InputCommand.LEFT, InputCommand.RIGHT);

    public static Guard getInstance() {
        return SingletonHolder.instance;
    }

    private Guard() {
    }

    public void register() {
        LivingAttackEvent.EVENT.register(this::onLivingAttack);
    }

    public void onLivingAttack(LivingAttackEvent event) {
        class_1937 class_19372;
        class_1297 entity;
        boolean isProjectile;
        class_1309 victim = event.getEntity();
        class_1282 source = event.getSource();
        class_1799 stack = victim.method_6047();
        Optional<ISlashBladeState> slashBlade = CapabilitySlashBlade.getBladeState(stack);
        if (slashBlade.isEmpty()) {
            return;
        }
        if (slashBlade.filter(ISlashBladeState::isBroken).isPresent()) {
            return;
        }
        class_6880.class_6883 thorns = victim.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_9097);
        if (class_1890.method_8225((class_6880)thorns, (class_1799)stack) <= 0) {
            return;
        }
        if (!victim.method_24828()) {
            return;
        }
        Optional input = CapabilityInputState.INPUT_STATE.maybeGet((Object)victim);
        if (input.isEmpty()) {
            return;
        }
        InputCommand targetCommand = InputCommand.SNEAK;
        boolean handleCommand = input.filter(i -> {
            if (!i.getCommands().contains((Object)targetCommand)) return false;
            if (!i.getCommands().stream().noneMatch(move::contains)) return false;
            return true;
        }).isPresent();
        if (handleCommand) {
            AdvancementHelper.grantCriterion(victim, ADVANCEMENT_GUARD);
        }
        if (!(handleCommand |= input.filter(i -> i.getCommands().contains((Object)InputCommand.SPRINT)).isPresent() && victim.method_5624())) {
            return;
        }
        if (!this.isInsideGuardableRange(source, victim)) {
            return;
        }
        long timeStartPress = input.map(i -> {
            Long l = i.getLastPressTime(targetCommand);
            return l == null ? 0L : l;
        }).get();
        long timeCurrent = victim.method_37908().method_8510();
        class_6880.class_6883 soulSpeed = victim.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_23071);
        int soulSpeedLevel = class_1890.method_8203((class_6880)soulSpeed, (class_1309)victim);
        int justAcceptancePeriod = 5 + soulSpeedLevel;
        boolean isJust = false;
        if (timeCurrent - timeStartPress < (long)justAcceptancePeriod) {
            isJust = true;
            AdvancementHelper.grantedIf((class_5321<class_1887>)class_1893.field_23071, victim);
        }
        boolean isHighRank = false;
        Optional rank = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)victim);
        if (rank.filter(r -> IConcentrationRank.ConcentrationRanks.S.level <= r.getRank((long)timeCurrent).level).isPresent()) {
            isHighRank = true;
        }
        boolean bl = isProjectile = source.method_48789(class_8103.field_42247) || source.method_5526() instanceof class_1676;
        if (!isJust) {
            if (!isProjectile) {
                return;
            }
            if (!isHighRank && source.method_48789(class_8103.field_42241)) {
                return;
            }
            boolean inMotion = slashBlade.filter(s -> {
                class_2960 current = s.resolvCurrentComboState(victim);
                ComboState currentCS = (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(current);
                return !current.equals((Object)ComboStateRegistry.getId(ComboStateRegistry.NONE)) && current == currentCS.getNext(victim);
            }).isPresent();
            if (inMotion) {
                return;
            }
        } else if (!isProjectile && !(source.method_5526() instanceof class_1309)) {
            return;
        }
        event.setCanceled(true);
        if (isJust) {
            slashBlade.ifPresent(s -> s.updateComboSeq(victim, ComboStateRegistry.getId(ComboStateRegistry.COMBO_A1)));
        } else {
            slashBlade.ifPresent(s -> s.updateComboSeq(victim, ComboStateRegistry.getId(ComboStateRegistry.COMBO_A1_END2)));
        }
        if (!isProjectile && (entity = source.method_5526()) instanceof class_1309) {
            ((class_1309)entity).method_6005(0.5, entity.method_23317() - victim.method_23317(), entity.method_23321() - victim.method_23321());
        }
        if (isJust) {
            Untouchable.setUntouchable(victim, 10);
        }
        if (isJust) {
            rank.ifPresent(r -> r.addRankPoint(victim.method_37908().method_48963().method_48818((class_1297)victim)));
        }
        if (victim instanceof class_1657) {
            victim.method_5783(class_3417.field_15104, 1.0f, 1.0f + victim.method_37908().method_8409().method_43057() * 0.4f);
        }
        if (isJust) {
            AdvancementHelper.grantCriterion(victim, ADVANCEMENT_GUARD_JUST);
        }
        if (!isJust && !isHighRank && (class_19372 = victim.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            slashBlade.ifPresent(s -> {
                class_3222 sp;
                class_3222 serverPlayer = victim instanceof class_3222 ? (sp = (class_3222)victim) : null;
                stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, victim));
            });
        }
    }

    public boolean isInsideGuardableRange(class_1282 source, class_1309 victim) {
        class_243 sPos = source.method_5510();
        if (sPos != null) {
            class_243 viewVec = victim.method_5828(1.0f);
            class_243 attackVec = sPos.method_1035(victim.method_19538()).method_1029();
            attackVec = new class_243(attackVec.field_1352, 0.0, attackVec.field_1350);
            return attackVec.method_1026(viewVec) < 0.0;
        }
        return false;
    }

    private static final class SingletonHolder {
        private static final Guard instance = new Guard();

        private SingletonHolder() {
        }
    }
}

